/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.Context;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIpForServer;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.extensions.FloatingIPApi;
import org.jclouds.rest.ApiContext;

public class RemoveFloatingIpFromNodeAndDeallocate
implements Function<RegionAndId, RegionAndId> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @Inject(optional=true)
    @Named(value="openstack-neutron")
    private Supplier<Context> neutronContextSupplier;
    private final NovaApi novaApi;
    private final LoadingCache<RegionAndId, Iterable<? extends FloatingIpForServer>> floatingIpCache;

    @Inject
    public RemoveFloatingIpFromNodeAndDeallocate(NovaApi novaApi, @Named(value="FLOATINGIP") LoadingCache<RegionAndId, Iterable<? extends FloatingIpForServer>> floatingIpCache) {
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
        this.floatingIpCache = (LoadingCache)Preconditions.checkNotNull(floatingIpCache, (Object)"floatingIpCache");
    }

    public RegionAndId apply(RegionAndId id) {
        if (this.isNeutronLinked()) {
            for (FloatingIpForServer floatingIpForServer : (Iterable)this.floatingIpCache.getUnchecked((Object)id)) {
                this.logger.debug(">> deallocating floatingIp(%s)", new Object[]{floatingIpForServer});
                this.getFloatingIPApi(id.getRegion()).delete(floatingIpForServer.floatingIpId());
            }
        } else {
            FloatingIPApi floatingIpApi = (FloatingIPApi)this.novaApi.getFloatingIPApi(id.getRegion()).get();
            for (FloatingIpForServer floatingIpForServer : (Iterable)this.floatingIpCache.getUnchecked((Object)id)) {
                this.logger.debug(">> removing floatingIp(%s) from node(%s)", new Object[]{floatingIpForServer, id});
                floatingIpApi.removeFromServer(floatingIpForServer.ip(), id.getId());
                this.logger.debug(">> deallocating floatingIp(%s)", new Object[]{floatingIpForServer});
                floatingIpApi.delete(floatingIpForServer.floatingIpId());
            }
        }
        this.floatingIpCache.invalidate((Object)id);
        return id;
    }

    private boolean isNeutronLinked() {
        return this.neutronContextSupplier != null && this.neutronContextSupplier.get() != null;
    }

    private org.jclouds.openstack.neutron.v2.features.FloatingIPApi getFloatingIPApi(String region) {
        return ((NeutronApi)((ApiContext)this.neutronContextSupplier.get()).getApi()).getFloatingIPApi(region);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RemoveFloatingIpFromNodeAndDeallocate").toString();
    }
}

