/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.nova.v2_0.domain.AutoValue_PortInterface;
import org.jclouds.openstack.nova.v2_0.domain.FixedIP;

public abstract class PortInterface {
    public abstract String portId();

    public abstract String netId();

    public abstract State portState();

    public abstract List<FixedIP> fixedIPS();

    @SerializedNames(value={"port_id", "net_id", "port_state", "fixed_ips"})
    public static PortInterface create(String portId, String netId, State portState, List<FixedIP> fixedIPS) {
        return new AutoValue_PortInterface(portId, netId, portState, (List<FixedIP>)(fixedIPS == null ? ImmutableList.of() : ImmutableList.copyOf(fixedIPS)));
    }

    PortInterface() {
    }

    public static enum State {
        PROVISIONING,
        QUEUED,
        ACTIVE;


        public static State fromValue(String value) {
            Optional state = Enums.getIfPresent(State.class, (String)value.toUpperCase());
            Preconditions.checkArgument((boolean)state.isPresent(), (String)"Expected one of %s but was %s", (Object)Joiner.on((char)',').join((Object[])State.values()), (Object)value);
            return (State)((Object)state.get());
        }
    }
}

