/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.base.Preconditions;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class CreateVolumeOptions
extends BaseEC2RequestOptions {
    public CreateVolumeOptions withSize(int size) {
        this.formParameters.put((Object)"Size", (Object)Integer.toString(size));
        return this;
    }

    public int getSize() {
        return Integer.parseInt(this.getFirstFormOrNull("Size"));
    }

    public CreateVolumeOptions fromSnapshotId(String snapshotId) {
        this.formParameters.put((Object)"SnapshotId", (Object)((String)Preconditions.checkNotNull((Object)snapshotId, (Object)"snapshotId")));
        return this;
    }

    public String getSnapshotId() {
        return this.getFirstFormOrNull("SnapshotId");
    }

    public CreateVolumeOptions volumeType(String volumeType) {
        this.formParameters.put((Object)"VolumeType", (Object)((String)Preconditions.checkNotNull((Object)volumeType, (Object)"volumeType")));
        return this;
    }

    public String getVolumeType() {
        return this.getFirstFormOrNull("VolumeType");
    }

    public CreateVolumeOptions withIops(Integer iops) {
        this.formParameters.put((Object)"Iops", (Object)((Integer)Preconditions.checkNotNull((Object)iops, (Object)"iops")).toString());
        return this;
    }

    public Integer getIops() {
        return Integer.valueOf(this.getFirstFormOrNull("Iops"));
    }

    public CreateVolumeOptions isEncrypted(boolean encrypted) {
        if (encrypted) {
            this.formParameters.put((Object)"Encrypted", (Object)"true");
        }
        return this;
    }

    public boolean getEncrypted() {
        return Boolean.parseBoolean(this.getFirstFormOrNull("Encrypted"));
    }

    public static class Builder {
        public static CreateVolumeOptions fromSnapshotId(String snapshotId) {
            CreateVolumeOptions options = new CreateVolumeOptions();
            return options.fromSnapshotId(snapshotId);
        }

        public static CreateVolumeOptions withSize(int size) {
            CreateVolumeOptions options = new CreateVolumeOptions();
            return options.withSize(size);
        }

        public static CreateVolumeOptions volumeType(String volumeType) {
            CreateVolumeOptions options = new CreateVolumeOptions();
            return options.volumeType(volumeType);
        }

        public static CreateVolumeOptions withIops(Integer iops) {
            CreateVolumeOptions options = new CreateVolumeOptions();
            return options.withIops(iops);
        }

        public static CreateVolumeOptions isEncrypted(boolean encrypted) {
            CreateVolumeOptions options = new CreateVolumeOptions();
            return options.isEncrypted(encrypted);
        }
    }
}

