/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.rbac.Subject;
import io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterClaimSpecFluent<A extends ClusterClaimSpecFluent<A>>
extends BaseFluent<A> {
    private String clusterPoolName;
    private Duration lifetime;
    private String namespace;
    private List<Subject> subjects = new ArrayList<Subject>();
    private Map<String, Object> additionalProperties;

    public ClusterClaimSpecFluent() {
    }

    public ClusterClaimSpecFluent(ClusterClaimSpec instance) {
        ClusterClaimSpec clusterClaimSpec = instance = instance != null ? instance : new ClusterClaimSpec();
        if (instance != null) {
            this.withClusterPoolName(instance.getClusterPoolName());
            this.withLifetime(instance.getLifetime());
            this.withNamespace(instance.getNamespace());
            this.withSubjects(instance.getSubjects());
            this.withClusterPoolName(instance.getClusterPoolName());
            this.withLifetime(instance.getLifetime());
            this.withNamespace(instance.getNamespace());
            this.withSubjects(instance.getSubjects());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getClusterPoolName() {
        return this.clusterPoolName;
    }

    public A withClusterPoolName(String clusterPoolName) {
        this.clusterPoolName = clusterPoolName;
        return (A)((Object)this);
    }

    public boolean hasClusterPoolName() {
        return this.clusterPoolName != null;
    }

    public Duration getLifetime() {
        return this.lifetime;
    }

    public A withLifetime(Duration lifetime) {
        this.lifetime = lifetime;
        return (A)((Object)this);
    }

    public boolean hasLifetime() {
        return this.lifetime != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public A addToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<Subject>();
        }
        this.subjects.add(index, item);
        return (A)((Object)this);
    }

    public A setToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<Subject>();
        }
        this.subjects.set(index, item);
        return (A)((Object)this);
    }

    public A addToSubjects(Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<Subject>();
        }
        for (Subject item : items) {
            this.subjects.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<Subject>();
        }
        for (Subject item : items) {
            this.subjects.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSubjects(Subject ... items) {
        if (this.subjects == null) {
            return (A)((Object)this);
        }
        for (Subject item : items) {
            this.subjects.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            return (A)((Object)this);
        }
        for (Subject item : items) {
            this.subjects.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Subject> getSubjects() {
        return this.subjects;
    }

    public Subject getSubject(int index) {
        return this.subjects.get(index);
    }

    public Subject getFirstSubject() {
        return this.subjects.get(0);
    }

    public Subject getLastSubject() {
        return this.subjects.get(this.subjects.size() - 1);
    }

    public Subject getMatchingSubject(Predicate<Subject> predicate) {
        for (Subject item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSubject(Predicate<Subject> predicate) {
        for (Subject item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjects(List<Subject> subjects) {
        if (subjects != null) {
            this.subjects = new ArrayList<Subject>();
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)((Object)this);
    }

    public A withSubjects(Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
            this._visitables.remove((Object)"subjects");
        }
        if (subjects != null) {
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    public A addNewSubject(String apiGroup, String kind, String name, String namespace) {
        return this.addToSubjects(new Subject(apiGroup, kind, name, namespace));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterClaimSpecFluent that = (ClusterClaimSpecFluent)((Object)o);
        if (!Objects.equals(this.clusterPoolName, that.clusterPoolName)) {
            return false;
        }
        if (!Objects.equals(this.lifetime, that.lifetime)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.subjects, that.subjects)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.clusterPoolName, this.lifetime, this.namespace, this.subjects, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterPoolName != null) {
            sb.append("clusterPoolName:");
            sb.append(this.clusterPoolName + ",");
        }
        if (this.lifetime != null) {
            sb.append("lifetime:");
            sb.append(this.lifetime + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

