/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ResourceRecordSet {
    protected final String name;
    protected final String type;
    protected final Optional<Integer> ttl;
    protected final List<String> values;
    protected final Optional<AliasTarget> aliasTarget;

    private ResourceRecordSet(String name, String type, Optional<Integer> ttl, List<String> values, Optional<AliasTarget> aliasTarget) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.type = (String)Preconditions.checkNotNull((Object)type, (String)"type of %s", (Object)name);
        this.ttl = (Optional)Preconditions.checkNotNull(ttl, (String)"ttl for %s", (Object)name);
        Preconditions.checkArgument(((Integer)ttl.or((Object)0) >= 0 ? 1 : 0) != 0, (String)"ttl of %s must be unsigned", (Object)name);
        this.values = (List)Preconditions.checkNotNull(values, (String)"values for %s", (Object)name);
        this.aliasTarget = (Optional)Preconditions.checkNotNull(aliasTarget, (String)"aliasTarget for %s", (Object)name);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Optional<Integer> getTTL() {
        return this.ttl;
    }

    public List<String> getValues() {
        return this.values;
    }

    public Optional<AliasTarget> getAliasTarget() {
        return this.aliasTarget;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceRecordSet other = (ResourceRecordSet)ResourceRecordSet.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.type, (Object)other.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("ttl", this.ttl.orNull()).add("values", this.values.isEmpty() ? null : this.values).add("aliasTarget", this.aliasTarget.orNull()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ResourceRecordSet.builder().from(this);
    }

    public static final class Builder {
        private String id;
        private String name;
        private String type;
        private Optional<Integer> ttl = Optional.absent();
        private ImmutableList.Builder<String> values = ImmutableList.builder();
        private String dnsName;
        private String zoneId;
        private Integer weight;
        private String region;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = Optional.of((Object)ttl);
            return this;
        }

        public Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder aliasTarget(AliasTarget aliasTarget) {
            if (aliasTarget == null) {
                this.dnsName = null;
                this.zoneId = null;
            } else {
                this.dnsName = aliasTarget.dnsName;
                this.zoneId = aliasTarget.zoneId;
            }
            return this;
        }

        public Builder add(String values) {
            this.values.add((Object)values);
            return this;
        }

        public Builder values(Iterable<String> values) {
            this.values = ImmutableList.builder().addAll(values);
            return this;
        }

        public Builder addAll(Iterable<String> values) {
            this.values.addAll(values);
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public ResourceRecordSet build() {
            Optional aliasTarget;
            Optional optional = aliasTarget = this.dnsName != null ? Optional.fromNullable((Object)AliasTarget.dnsNameInZone(this.dnsName, this.zoneId)) : Optional.absent();
            if (this.weight != null) {
                return new RecordSubset.Weighted(this.id, this.name, this.type, this.weight, this.ttl, (List)this.values.build(), aliasTarget);
            }
            if (this.region != null) {
                return new RecordSubset.Latency(this.id, this.name, this.type, this.region, this.ttl, (List)this.values.build(), aliasTarget);
            }
            return new ResourceRecordSet(this.name, this.type, this.ttl, (List)this.values.build(), aliasTarget);
        }

        public Builder from(ResourceRecordSet in) {
            if (in instanceof RecordSubset) {
                this.id(((RecordSubset)RecordSubset.class.cast(in)).id);
            }
            if (in instanceof RecordSubset.Weighted) {
                this.weight(((RecordSubset.Weighted)RecordSubset.Weighted.class.cast(in)).weight);
            } else if (in instanceof RecordSubset.Latency) {
                this.region(((RecordSubset.Latency)RecordSubset.Latency.class.cast(in)).region);
            }
            return this.name(in.name).type(in.type).ttl((Integer)in.ttl.orNull()).values(in.values).aliasTarget((AliasTarget)in.aliasTarget.orNull());
        }
    }

    public static abstract class RecordSubset
    extends ResourceRecordSet {
        private final String id;

        private RecordSubset(String id, String name, String type, Optional<Integer> ttl, List<String> values, Optional<AliasTarget> aliasTarget) {
            super(name, type, ttl, values, aliasTarget);
            this.id = (String)Preconditions.checkNotNull((Object)id, (String)"id of %s", (Object)name);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.id});
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof RecordSubset) {
                RecordSubset that = (RecordSubset)RecordSubset.class.cast(obj);
                return Objects.equal((Object)this.id, (Object)that.id);
            }
            return false;
        }

        abstract MoreObjects.ToStringHelper differentiate(MoreObjects.ToStringHelper var1);

        @Override
        public String toString() {
            return this.differentiate(MoreObjects.toStringHelper((String)"").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("type", (Object)this.type)).add("ttl", this.ttl.orNull()).add("values", (Object)(this.values.isEmpty() ? null : this.values)).add("aliasTarget", this.aliasTarget.orNull()).toString();
        }

        public static final class Latency
        extends RecordSubset {
            private final String region;

            private Latency(String id, String name, String type, String region, Optional<Integer> ttl, List<String> values, Optional<AliasTarget> aliasTarget) {
                super(id, name, type, ttl, values, aliasTarget);
                this.region = (String)Preconditions.checkNotNull((Object)region, (String)"region of %s", (Object)name);
            }

            public String getRegion() {
                return this.region;
            }

            @Override
            MoreObjects.ToStringHelper differentiate(MoreObjects.ToStringHelper in) {
                return in.add("region", (Object)this.region);
            }
        }

        public static final class Weighted
        extends RecordSubset {
            private final int weight;

            private Weighted(String id, String name, String type, int weight, Optional<Integer> ttl, List<String> values, Optional<AliasTarget> aliasTarget) {
                super(id, name, type, ttl, values, aliasTarget);
                this.weight = weight;
            }

            public int getWeight() {
                return this.weight;
            }

            @Override
            MoreObjects.ToStringHelper differentiate(MoreObjects.ToStringHelper in) {
                return in.add("weight", this.weight);
            }
        }
    }

    public static class AliasTarget {
        private final String dnsName;
        private final String zoneId;

        public static AliasTarget dnsNameInZone(String dnsName, String zoneId) {
            return new AliasTarget(dnsName, zoneId);
        }

        private AliasTarget(String dnsName, String zoneId) {
            this.dnsName = (String)Preconditions.checkNotNull((Object)dnsName, (Object)"dnsName");
            this.zoneId = (String)Preconditions.checkNotNull((Object)zoneId, (String)"zoneId of %s", (Object)dnsName);
        }

        public String getDNSName() {
            return this.dnsName;
        }

        public String getZoneId() {
            return this.zoneId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zoneId, this.dnsName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AliasTarget other = (AliasTarget)AliasTarget.class.cast(obj);
            return Objects.equal((Object)this.dnsName, (Object)other.dnsName) && Objects.equal((Object)this.zoneId, (Object)other.zoneId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"").omitNullValues().add("dnsName", (Object)this.dnsName).add("zoneId", (Object)this.zoneId).toString();
        }
    }
}

