/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeSpec;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsFluent;
import io.fabric8.openshift.api.model.monitoring.v1.ProberSpec;
import io.fabric8.openshift.api.model.monitoring.v1.ProberSpecBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.ProberSpecFluent;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ProbeSpecFluent<A extends ProbeSpecFluent<A>>
extends BaseFluent<A> {
    private SafeAuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private SecretKeySelector bearerTokenSecret;
    private String interval;
    private String jobName;
    private Long labelLimit;
    private Long labelNameLengthLimit;
    private Long labelValueLengthLimit;
    private ArrayList<RelabelConfigBuilder> metricRelabelings = new ArrayList();
    private String module;
    private OAuth2Builder oauth2;
    private ProberSpecBuilder prober;
    private Long sampleLimit;
    private String scrapeTimeout;
    private Long targetLimit;
    private ProbeTargetsBuilder targets;
    private ProbeTLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public ProbeSpecFluent() {
    }

    public ProbeSpecFluent(ProbeSpec instance) {
        ProbeSpec probeSpec = instance = instance != null ? instance : new ProbeSpec();
        if (instance != null) {
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withBearerTokenSecret(instance.getBearerTokenSecret());
            this.withInterval(instance.getInterval());
            this.withJobName(instance.getJobName());
            this.withLabelLimit(instance.getLabelLimit());
            this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
            this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
            this.withMetricRelabelings(instance.getMetricRelabelings());
            this.withModule(instance.getModule());
            this.withOauth2(instance.getOauth2());
            this.withProber(instance.getProber());
            this.withSampleLimit(instance.getSampleLimit());
            this.withScrapeTimeout(instance.getScrapeTimeout());
            this.withTargetLimit(instance.getTargetLimit());
            this.withTargets(instance.getTargets());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withBearerTokenSecret(instance.getBearerTokenSecret());
            this.withInterval(instance.getInterval());
            this.withJobName(instance.getJobName());
            this.withLabelLimit(instance.getLabelLimit());
            this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
            this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
            this.withMetricRelabelings(instance.getMetricRelabelings());
            this.withModule(instance.getModule());
            this.withOauth2(instance.getOauth2());
            this.withProber(instance.getProber());
            this.withSampleLimit(instance.getSampleLimit());
            this.withScrapeTimeout(instance.getScrapeTimeout());
            this.withTargetLimit(instance.getTargetLimit());
            this.withTargets(instance.getTargets());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SafeAuthorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(SafeAuthorization authorization) {
        this._visitables.get((Object)"authorization").remove((Object)this.authorization);
        if (authorization != null) {
            this.authorization = new SafeAuthorizationBuilder(authorization);
            this._visitables.get((Object)"authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get((Object)"authorization").remove((Object)this.authorization);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.get((Object)"basicAuth").remove((Object)this.basicAuth);
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get((Object)"basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get((Object)"basicAuth").remove((Object)this.basicAuth);
        }
        return (A)((Object)this);
    }

    public boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNested(null);
    }

    public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNested(item);
    }

    public BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(null));
    }

    public BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
    }

    public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(item));
    }

    public SecretKeySelector getBearerTokenSecret() {
        return this.bearerTokenSecret;
    }

    public A withBearerTokenSecret(SecretKeySelector bearerTokenSecret) {
        this.bearerTokenSecret = bearerTokenSecret;
        return (A)((Object)this);
    }

    public boolean hasBearerTokenSecret() {
        return this.bearerTokenSecret != null;
    }

    public A withNewBearerTokenSecret(String key, String name, Boolean optional) {
        return this.withBearerTokenSecret(new SecretKeySelector(key, name, optional));
    }

    public String getInterval() {
        return this.interval;
    }

    public A withInterval(String interval) {
        this.interval = interval;
        return (A)((Object)this);
    }

    public boolean hasInterval() {
        return this.interval != null;
    }

    public String getJobName() {
        return this.jobName;
    }

    public A withJobName(String jobName) {
        this.jobName = jobName;
        return (A)((Object)this);
    }

    public boolean hasJobName() {
        return this.jobName != null;
    }

    public Long getLabelLimit() {
        return this.labelLimit;
    }

    public A withLabelLimit(Long labelLimit) {
        this.labelLimit = labelLimit;
        return (A)((Object)this);
    }

    public boolean hasLabelLimit() {
        return this.labelLimit != null;
    }

    public Long getLabelNameLengthLimit() {
        return this.labelNameLengthLimit;
    }

    public A withLabelNameLengthLimit(Long labelNameLengthLimit) {
        this.labelNameLengthLimit = labelNameLengthLimit;
        return (A)((Object)this);
    }

    public boolean hasLabelNameLengthLimit() {
        return this.labelNameLengthLimit != null;
    }

    public Long getLabelValueLengthLimit() {
        return this.labelValueLengthLimit;
    }

    public A withLabelValueLengthLimit(Long labelValueLengthLimit) {
        this.labelValueLengthLimit = labelValueLengthLimit;
        return (A)((Object)this);
    }

    public boolean hasLabelValueLengthLimit() {
        return this.labelValueLengthLimit != null;
    }

    public A addToMetricRelabelings(int index, RelabelConfig item) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.metricRelabelings.size()) {
            this._visitables.get((Object)"metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        } else {
            this._visitables.get((Object)"metricRelabelings").add(index, builder);
            this.metricRelabelings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMetricRelabelings(int index, RelabelConfig item) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.metricRelabelings.size()) {
            this._visitables.get((Object)"metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        } else {
            this._visitables.get((Object)"metricRelabelings").set(index, builder);
            this.metricRelabelings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMetricRelabelings(RelabelConfig ... items) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMetricRelabelings(Collection<RelabelConfig> items) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMetricRelabelings(RelabelConfig ... items) {
        if (this.metricRelabelings == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"metricRelabelings").remove((Object)builder);
            this.metricRelabelings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items) {
        if (this.metricRelabelings == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"metricRelabelings").remove((Object)builder);
            this.metricRelabelings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMetricRelabelings(Predicate<RelabelConfigBuilder> predicate) {
        if (this.metricRelabelings == null) {
            return (A)((Object)this);
        }
        Iterator<RelabelConfigBuilder> each = this.metricRelabelings.iterator();
        List visitables = this._visitables.get((Object)"metricRelabelings");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RelabelConfig> buildMetricRelabelings() {
        return this.metricRelabelings != null ? ProbeSpecFluent.build(this.metricRelabelings) : null;
    }

    public RelabelConfig buildMetricRelabeling(int index) {
        return this.metricRelabelings.get(index).build();
    }

    public RelabelConfig buildFirstMetricRelabeling() {
        return this.metricRelabelings.get(0).build();
    }

    public RelabelConfig buildLastMetricRelabeling() {
        return this.metricRelabelings.get(this.metricRelabelings.size() - 1).build();
    }

    public RelabelConfig buildMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.metricRelabelings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.metricRelabelings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMetricRelabelings(List<RelabelConfig> metricRelabelings) {
        if (this.metricRelabelings != null) {
            this._visitables.get((Object)"metricRelabelings").clear();
        }
        if (metricRelabelings != null) {
            this.metricRelabelings = new ArrayList();
            for (RelabelConfig item : metricRelabelings) {
                this.addToMetricRelabelings(item);
            }
        } else {
            this.metricRelabelings = null;
        }
        return (A)((Object)this);
    }

    public A withMetricRelabelings(RelabelConfig ... metricRelabelings) {
        if (this.metricRelabelings != null) {
            this.metricRelabelings.clear();
            this._visitables.remove((Object)"metricRelabelings");
        }
        if (metricRelabelings != null) {
            for (RelabelConfig item : metricRelabelings) {
                this.addToMetricRelabelings(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMetricRelabelings() {
        return this.metricRelabelings != null && !this.metricRelabelings.isEmpty();
    }

    public MetricRelabelingsNested<A> addNewMetricRelabeling() {
        return new MetricRelabelingsNested(-1, null);
    }

    public MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item) {
        return new MetricRelabelingsNested(-1, item);
    }

    public MetricRelabelingsNested<A> setNewMetricRelabelingLike(int index, RelabelConfig item) {
        return new MetricRelabelingsNested(index, item);
    }

    public MetricRelabelingsNested<A> editMetricRelabeling(int index) {
        if (this.metricRelabelings.size() <= index) {
            throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    public MetricRelabelingsNested<A> editFirstMetricRelabeling() {
        if (this.metricRelabelings.size() == 0) {
            throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
        }
        return this.setNewMetricRelabelingLike(0, this.buildMetricRelabeling(0));
    }

    public MetricRelabelingsNested<A> editLastMetricRelabeling() {
        int index = this.metricRelabelings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    public MetricRelabelingsNested<A> editMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metricRelabelings.size(); ++i) {
            if (!predicate.test(this.metricRelabelings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    public String getModule() {
        return this.module;
    }

    public A withModule(String module) {
        this.module = module;
        return (A)((Object)this);
    }

    public boolean hasModule() {
        return this.module != null;
    }

    public OAuth2 buildOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    public A withOauth2(OAuth2 oauth2) {
        this._visitables.get((Object)"oauth2").remove((Object)this.oauth2);
        if (oauth2 != null) {
            this.oauth2 = new OAuth2Builder(oauth2);
            this._visitables.get((Object)"oauth2").add(this.oauth2);
        } else {
            this.oauth2 = null;
            this._visitables.get((Object)"oauth2").remove((Object)this.oauth2);
        }
        return (A)((Object)this);
    }

    public boolean hasOauth2() {
        return this.oauth2 != null;
    }

    public Oauth2Nested<A> withNewOauth2() {
        return new Oauth2Nested(null);
    }

    public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
        return new Oauth2Nested(item);
    }

    public Oauth2Nested<A> editOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(null));
    }

    public Oauth2Nested<A> editOrNewOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(new OAuth2Builder().build()));
    }

    public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(item));
    }

    public ProberSpec buildProber() {
        return this.prober != null ? this.prober.build() : null;
    }

    public A withProber(ProberSpec prober) {
        this._visitables.get((Object)"prober").remove((Object)this.prober);
        if (prober != null) {
            this.prober = new ProberSpecBuilder(prober);
            this._visitables.get((Object)"prober").add(this.prober);
        } else {
            this.prober = null;
            this._visitables.get((Object)"prober").remove((Object)this.prober);
        }
        return (A)((Object)this);
    }

    public boolean hasProber() {
        return this.prober != null;
    }

    public A withNewProber(String path, String proxyUrl, String scheme, String url) {
        return this.withProber(new ProberSpec(path, proxyUrl, scheme, url));
    }

    public ProberNested<A> withNewProber() {
        return new ProberNested(null);
    }

    public ProberNested<A> withNewProberLike(ProberSpec item) {
        return new ProberNested(item);
    }

    public ProberNested<A> editProber() {
        return this.withNewProberLike(Optional.ofNullable(this.buildProber()).orElse(null));
    }

    public ProberNested<A> editOrNewProber() {
        return this.withNewProberLike(Optional.ofNullable(this.buildProber()).orElse(new ProberSpecBuilder().build()));
    }

    public ProberNested<A> editOrNewProberLike(ProberSpec item) {
        return this.withNewProberLike(Optional.ofNullable(this.buildProber()).orElse(item));
    }

    public Long getSampleLimit() {
        return this.sampleLimit;
    }

    public A withSampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
        return (A)((Object)this);
    }

    public boolean hasSampleLimit() {
        return this.sampleLimit != null;
    }

    public String getScrapeTimeout() {
        return this.scrapeTimeout;
    }

    public A withScrapeTimeout(String scrapeTimeout) {
        this.scrapeTimeout = scrapeTimeout;
        return (A)((Object)this);
    }

    public boolean hasScrapeTimeout() {
        return this.scrapeTimeout != null;
    }

    public Long getTargetLimit() {
        return this.targetLimit;
    }

    public A withTargetLimit(Long targetLimit) {
        this.targetLimit = targetLimit;
        return (A)((Object)this);
    }

    public boolean hasTargetLimit() {
        return this.targetLimit != null;
    }

    public ProbeTargets buildTargets() {
        return this.targets != null ? this.targets.build() : null;
    }

    public A withTargets(ProbeTargets targets) {
        this._visitables.get((Object)"targets").remove((Object)this.targets);
        if (targets != null) {
            this.targets = new ProbeTargetsBuilder(targets);
            this._visitables.get((Object)"targets").add(this.targets);
        } else {
            this.targets = null;
            this._visitables.get((Object)"targets").remove((Object)this.targets);
        }
        return (A)((Object)this);
    }

    public boolean hasTargets() {
        return this.targets != null;
    }

    public TargetsNested<A> withNewTargets() {
        return new TargetsNested(null);
    }

    public TargetsNested<A> withNewTargetsLike(ProbeTargets item) {
        return new TargetsNested(item);
    }

    public TargetsNested<A> editTargets() {
        return this.withNewTargetsLike(Optional.ofNullable(this.buildTargets()).orElse(null));
    }

    public TargetsNested<A> editOrNewTargets() {
        return this.withNewTargetsLike(Optional.ofNullable(this.buildTargets()).orElse(new ProbeTargetsBuilder().build()));
    }

    public TargetsNested<A> editOrNewTargetsLike(ProbeTargets item) {
        return this.withNewTargetsLike(Optional.ofNullable(this.buildTargets()).orElse(item));
    }

    public ProbeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(ProbeTLSConfig tlsConfig) {
        this._visitables.get((Object)"tlsConfig").remove((Object)this.tlsConfig);
        if (tlsConfig != null) {
            this.tlsConfig = new ProbeTLSConfigBuilder(tlsConfig);
            this._visitables.get((Object)"tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get((Object)"tlsConfig").remove((Object)this.tlsConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(ProbeTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new ProbeTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(ProbeTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProbeSpecFluent that = (ProbeSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.authorization, (Object)that.authorization)) {
            return false;
        }
        if (!Objects.equals((Object)this.basicAuth, (Object)that.basicAuth)) {
            return false;
        }
        if (!Objects.equals(this.bearerTokenSecret, that.bearerTokenSecret)) {
            return false;
        }
        if (!Objects.equals(this.interval, that.interval)) {
            return false;
        }
        if (!Objects.equals(this.jobName, that.jobName)) {
            return false;
        }
        if (!Objects.equals(this.labelLimit, that.labelLimit)) {
            return false;
        }
        if (!Objects.equals(this.labelNameLengthLimit, that.labelNameLengthLimit)) {
            return false;
        }
        if (!Objects.equals(this.labelValueLengthLimit, that.labelValueLengthLimit)) {
            return false;
        }
        if (!Objects.equals(this.metricRelabelings, that.metricRelabelings)) {
            return false;
        }
        if (!Objects.equals(this.module, that.module)) {
            return false;
        }
        if (!Objects.equals((Object)this.oauth2, (Object)that.oauth2)) {
            return false;
        }
        if (!Objects.equals((Object)this.prober, (Object)that.prober)) {
            return false;
        }
        if (!Objects.equals(this.sampleLimit, that.sampleLimit)) {
            return false;
        }
        if (!Objects.equals(this.scrapeTimeout, that.scrapeTimeout)) {
            return false;
        }
        if (!Objects.equals(this.targetLimit, that.targetLimit)) {
            return false;
        }
        if (!Objects.equals((Object)this.targets, (Object)that.targets)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsConfig, (Object)that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorization, this.basicAuth, this.bearerTokenSecret, this.interval, this.jobName, this.labelLimit, this.labelNameLengthLimit, this.labelValueLengthLimit, this.metricRelabelings, this.module, this.oauth2, this.prober, this.sampleLimit, this.scrapeTimeout, this.targetLimit, this.targets, this.tlsConfig, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append((Object)((Object)this.authorization) + ",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append((Object)((Object)this.basicAuth) + ",");
        }
        if (this.bearerTokenSecret != null) {
            sb.append("bearerTokenSecret:");
            sb.append(this.bearerTokenSecret + ",");
        }
        if (this.interval != null) {
            sb.append("interval:");
            sb.append(this.interval + ",");
        }
        if (this.jobName != null) {
            sb.append("jobName:");
            sb.append(this.jobName + ",");
        }
        if (this.labelLimit != null) {
            sb.append("labelLimit:");
            sb.append(this.labelLimit + ",");
        }
        if (this.labelNameLengthLimit != null) {
            sb.append("labelNameLengthLimit:");
            sb.append(this.labelNameLengthLimit + ",");
        }
        if (this.labelValueLengthLimit != null) {
            sb.append("labelValueLengthLimit:");
            sb.append(this.labelValueLengthLimit + ",");
        }
        if (this.metricRelabelings != null && !this.metricRelabelings.isEmpty()) {
            sb.append("metricRelabelings:");
            sb.append(this.metricRelabelings + ",");
        }
        if (this.module != null) {
            sb.append("module:");
            sb.append(this.module + ",");
        }
        if (this.oauth2 != null) {
            sb.append("oauth2:");
            sb.append((Object)((Object)this.oauth2) + ",");
        }
        if (this.prober != null) {
            sb.append("prober:");
            sb.append((Object)((Object)this.prober) + ",");
        }
        if (this.sampleLimit != null) {
            sb.append("sampleLimit:");
            sb.append(this.sampleLimit + ",");
        }
        if (this.scrapeTimeout != null) {
            sb.append("scrapeTimeout:");
            sb.append(this.scrapeTimeout + ",");
        }
        if (this.targetLimit != null) {
            sb.append("targetLimit:");
            sb.append(this.targetLimit + ",");
        }
        if (this.targets != null) {
            sb.append("targets:");
            sb.append((Object)((Object)this.targets) + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append((Object)((Object)this.tlsConfig) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TlsConfigNested<N>
    extends ProbeTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        ProbeTLSConfigBuilder builder;

        TlsConfigNested(ProbeTLSConfig item) {
            this.builder = new ProbeTLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)ProbeSpecFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class TargetsNested<N>
    extends ProbeTargetsFluent<TargetsNested<N>>
    implements Nested<N> {
        ProbeTargetsBuilder builder;

        TargetsNested(ProbeTargets item) {
            this.builder = new ProbeTargetsBuilder(this, item);
        }

        public N and() {
            return (N)ProbeSpecFluent.this.withTargets(this.builder.build());
        }

        public N endTargets() {
            return this.and();
        }
    }

    public class ProberNested<N>
    extends ProberSpecFluent<ProberNested<N>>
    implements Nested<N> {
        ProberSpecBuilder builder;

        ProberNested(ProberSpec item) {
            this.builder = new ProberSpecBuilder(this, item);
        }

        public N and() {
            return (N)ProbeSpecFluent.this.withProber(this.builder.build());
        }

        public N endProber() {
            return this.and();
        }
    }

    public class Oauth2Nested<N>
    extends OAuth2Fluent<Oauth2Nested<N>>
    implements Nested<N> {
        OAuth2Builder builder;

        Oauth2Nested(OAuth2 item) {
            this.builder = new OAuth2Builder(this, item);
        }

        public N and() {
            return (N)ProbeSpecFluent.this.withOauth2(this.builder.build());
        }

        public N endOauth2() {
            return this.and();
        }
    }

    public class MetricRelabelingsNested<N>
    extends RelabelConfigFluent<MetricRelabelingsNested<N>>
    implements Nested<N> {
        RelabelConfigBuilder builder;
        int index;

        MetricRelabelingsNested(int index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        public N and() {
            return (N)ProbeSpecFluent.this.setToMetricRelabelings(this.index, this.builder.build());
        }

        public N endMetricRelabeling() {
            return this.and();
        }
    }

    public class BasicAuthNested<N>
    extends BasicAuthFluent<BasicAuthNested<N>>
    implements Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNested(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        public N and() {
            return (N)ProbeSpecFluent.this.withBasicAuth(this.builder.build());
        }

        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends SafeAuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        SafeAuthorizationBuilder builder;

        AuthorizationNested(SafeAuthorization item) {
            this.builder = new SafeAuthorizationBuilder(this, item);
        }

        public N and() {
            return (N)ProbeSpecFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }
}

