/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import angular from 'angular';
import uiRouter from 'angular-ui-router';
import {HIDE_INTERSTITIAL_SPINNER_EVENT} from 'brooklyn-ui-utils/interstitial-spinner/interstitial-spinner';
import template from './wizard.template.html';

const MODULE_NAME = 'state.wizard';

angular.module(MODULE_NAME, [uiRouter])
    .config(['$stateProvider', wizardStateConfig]);

export default MODULE_NAME;

export const wizardState = {
    name: 'wizard',
    url: '/wizard',
    controller: ['$scope', '$state', wizardStateController],
    controllerAs: 'vm',
    template: template
};

export function wizardStateConfig($stateProvider) {
    $stateProvider.state(wizardState);
}

export function wizardStateController($scope, $state) {
    const {type} = $state;
    $scope.$emit(HIDE_INTERSTITIAL_SPINNER_EVENT);
    let vm = this;

    vm.type = type;

    vm.startWizard = function (type) {
        vm.type = type;
        $state.go('wizard.' + type);
    }
}
