/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.docling.DoclingComponent;

/**
 * Process documents using Docling library for parsing and conversion.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface DoclingComponentBuilderFactory {

    /**
     * Docling (camel-docling)
     * Process documents using Docling library for parsing and conversion.
     * 
     * Category: transformation,ai
     * Since: 4.15
     * Maven coordinates: org.apache.camel:camel-docling
     * 
     * @return the dsl builder
     */
    static DoclingComponentBuilder docling() {
        return new DoclingComponentBuilderImpl();
    }

    /**
     * Builder for the Docling component.
     */
    interface DoclingComponentBuilder extends ComponentBuilder<DoclingComponent> {
    
        /**
         * The configuration for the Docling Endpoint.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.docling.DoclingConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder configuration(org.apache.camel.component.docling.DoclingConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * Include the content of the output file in the exchange body and
         * delete the output file.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param contentInBody the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder contentInBody(boolean contentInBody) {
            doSetProperty("contentInBody", contentInBody);
            return this;
        }
    
        
        /**
         * Docling-serve API URL (e.g., http://localhost:5001).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: http://localhost:5001
         * Group: producer
         * 
         * @param doclingServeUrl the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder doclingServeUrl(java.lang.String doclingServeUrl) {
            doSetProperty("doclingServeUrl", doclingServeUrl);
            return this;
        }
    
        
        /**
         * Enable OCR processing for scanned documents.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param enableOCR the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder enableOCR(boolean enableOCR) {
            doSetProperty("enableOCR", enableOCR);
            return this;
        }
    
        
        /**
         * Show layout information with bounding boxes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param includeLayoutInfo the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder includeLayoutInfo(boolean includeLayoutInfo) {
            doSetProperty("includeLayoutInfo", includeLayoutInfo);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        
        /**
         * Language code for OCR processing.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: en
         * Group: producer
         * 
         * @param ocrLanguage the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder ocrLanguage(java.lang.String ocrLanguage) {
            doSetProperty("ocrLanguage", ocrLanguage);
            return this;
        }
    
        
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.docling.DoclingOperations&lt;/code&gt; type.
         * 
         * Default: CONVERT_TO_MARKDOWN
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder operation(org.apache.camel.component.docling.DoclingOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        
        /**
         * Output format for document conversion.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: markdown
         * Group: producer
         * 
         * @param outputFormat the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder outputFormat(java.lang.String outputFormat) {
            doSetProperty("outputFormat", outputFormat);
            return this;
        }
    
        
        /**
         * Use docling-serve API instead of CLI command.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDoclingServe the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder useDoclingServe(boolean useDoclingServe) {
            doSetProperty("useDoclingServe", useDoclingServe);
            return this;
        }
    
        
        /**
         * API request timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: advanced
         * 
         * @param apiTimeout the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder apiTimeout(long apiTimeout) {
            doSetProperty("apiTimeout", apiTimeout);
            return this;
        }
    
        
        /**
         * Polling interval for async conversion status in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 2000
         * Group: advanced
         * 
         * @param asyncPollInterval the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder asyncPollInterval(long asyncPollInterval) {
            doSetProperty("asyncPollInterval", asyncPollInterval);
            return this;
        }
    
        
        /**
         * Maximum time to wait for async conversion completion in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: advanced
         * 
         * @param asyncTimeout the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder asyncTimeout(long asyncTimeout) {
            doSetProperty("asyncTimeout", asyncTimeout);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        
        /**
         * Connection request timeout in milliseconds (timeout when requesting
         * connection from pool).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectionRequestTimeout the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder connectionRequestTimeout(int connectionRequestTimeout) {
            doSetProperty("connectionRequestTimeout", connectionRequestTimeout);
            return this;
        }
    
        
        /**
         * Connection timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder connectionTimeout(int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
    
        
        /**
         * Time to live for connections in milliseconds (-1 for infinite).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param connectionTimeToLive the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder connectionTimeToLive(long connectionTimeToLive) {
            doSetProperty("connectionTimeToLive", connectionTimeToLive);
            return this;
        }
    
        
        /**
         * Docling-serve API convert endpoint path.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /v1/convert/source
         * Group: advanced
         * 
         * @param convertEndpoint the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder convertEndpoint(java.lang.String convertEndpoint) {
            doSetProperty("convertEndpoint", convertEndpoint);
            return this;
        }
    
        /**
         * Path to Docling Python executable or command.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param doclingCommand the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder doclingCommand(java.lang.String doclingCommand) {
            doSetProperty("doclingCommand", doclingCommand);
            return this;
        }
    
        
        /**
         * Enable eviction of idle connections from the pool.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param evictIdleConnections the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder evictIdleConnections(boolean evictIdleConnections) {
            doSetProperty("evictIdleConnections", evictIdleConnections);
            return this;
        }
    
        
        /**
         * Maximum connections per route in the connection pool.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: advanced
         * 
         * @param maxConnectionsPerRoute the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder maxConnectionsPerRoute(int maxConnectionsPerRoute) {
            doSetProperty("maxConnectionsPerRoute", maxConnectionsPerRoute);
            return this;
        }
    
        
        /**
         * Maximum idle time for connections in milliseconds before eviction.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: advanced
         * 
         * @param maxIdleTime the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder maxIdleTime(long maxIdleTime) {
            doSetProperty("maxIdleTime", maxIdleTime);
            return this;
        }
    
        
        /**
         * Maximum total connections in the connection pool.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 20
         * Group: advanced
         * 
         * @param maxTotalConnections the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder maxTotalConnections(int maxTotalConnections) {
            doSetProperty("maxTotalConnections", maxTotalConnections);
            return this;
        }
    
        
        /**
         * Timeout for Docling process execution in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param processTimeout the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder processTimeout(long processTimeout) {
            doSetProperty("processTimeout", processTimeout);
            return this;
        }
    
        
        /**
         * Socket timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: advanced
         * 
         * @param socketTimeout the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder socketTimeout(int socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
    
        
        /**
         * Use asynchronous conversion mode (docling-serve API only).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useAsyncMode the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder useAsyncMode(boolean useAsyncMode) {
            doSetProperty("useAsyncMode", useAsyncMode);
            return this;
        }
    
        
        /**
         * Validate connections after inactivity in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2000
         * Group: advanced
         * 
         * @param validateAfterInactivity the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder validateAfterInactivity(int validateAfterInactivity) {
            doSetProperty("validateAfterInactivity", validateAfterInactivity);
            return this;
        }
    
        /**
         * Working directory for Docling execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workingDirectory the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder workingDirectory(java.lang.String workingDirectory) {
            doSetProperty("workingDirectory", workingDirectory);
            return this;
        }
    
        
        /**
         * Fail entire batch on first error (true) or continue processing
         * remaining documents (false).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: batch
         * 
         * @param batchFailOnFirstError the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder batchFailOnFirstError(boolean batchFailOnFirstError) {
            doSetProperty("batchFailOnFirstError", batchFailOnFirstError);
            return this;
        }
    
        
        /**
         * Number of parallel threads for batch processing.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4
         * Group: batch
         * 
         * @param batchParallelism the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder batchParallelism(int batchParallelism) {
            doSetProperty("batchParallelism", batchParallelism);
            return this;
        }
    
        
        /**
         * Maximum number of documents to process in a single batch (batch
         * operations only).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: batch
         * 
         * @param batchSize the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder batchSize(int batchSize) {
            doSetProperty("batchSize", batchSize);
            return this;
        }
    
        
        /**
         * Maximum time to wait for batch completion in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: batch
         * 
         * @param batchTimeout the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder batchTimeout(long batchTimeout) {
            doSetProperty("batchTimeout", batchTimeout);
            return this;
        }
    
        
        /**
         * Split batch results into individual exchanges (one per document)
         * instead of single BatchProcessingResults.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: batch
         * 
         * @param splitBatchResults the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder splitBatchResults(boolean splitBatchResults) {
            doSetProperty("splitBatchResults", splitBatchResults);
            return this;
        }
    
        
        /**
         * Extract all available metadata fields including custom/raw fields.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: metadata
         * 
         * @param extractAllMetadata the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder extractAllMetadata(boolean extractAllMetadata) {
            doSetProperty("extractAllMetadata", extractAllMetadata);
            return this;
        }
    
        
        /**
         * Include metadata in message headers when extracting metadata.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: metadata
         * 
         * @param includeMetadataInHeaders the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder includeMetadataInHeaders(boolean includeMetadataInHeaders) {
            doSetProperty("includeMetadataInHeaders", includeMetadataInHeaders);
            return this;
        }
    
        
        /**
         * Include raw metadata as returned by the parser.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: metadata
         * 
         * @param includeRawMetadata the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder includeRawMetadata(boolean includeRawMetadata) {
            doSetProperty("includeRawMetadata", includeRawMetadata);
            return this;
        }
    
        
        /**
         * Header name for API key authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: X-API-Key
         * Group: security
         * 
         * @param apiKeyHeader the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder apiKeyHeader(java.lang.String apiKeyHeader) {
            doSetProperty("apiKeyHeader", apiKeyHeader);
            return this;
        }
    
        
        /**
         * Authentication scheme (BEARER, API_KEY, NONE).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.docling.AuthenticationScheme&lt;/code&gt; type.
         * 
         * Default: NONE
         * Group: security
         * 
         * @param authenticationScheme the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder authenticationScheme(org.apache.camel.component.docling.AuthenticationScheme authenticationScheme) {
            doSetProperty("authenticationScheme", authenticationScheme);
            return this;
        }
    
        /**
         * Authentication token for docling-serve API (Bearer token or API key).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authenticationToken the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder authenticationToken(java.lang.String authenticationToken) {
            doSetProperty("authenticationToken", authenticationToken);
            return this;
        }
    
        
        /**
         * Maximum file size in bytes for processing.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 52428800
         * Group: security
         * 
         * @param maxFileSize the value to set
         * @return the dsl builder
         */
        default DoclingComponentBuilder maxFileSize(long maxFileSize) {
            doSetProperty("maxFileSize", maxFileSize);
            return this;
        }
    }

    class DoclingComponentBuilderImpl
            extends AbstractComponentBuilder<DoclingComponent>
            implements DoclingComponentBuilder {
        @Override
        protected DoclingComponent buildConcreteComponent() {
            return new DoclingComponent();
        }
        private org.apache.camel.component.docling.DoclingConfiguration getOrCreateConfiguration(DoclingComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.docling.DoclingConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((DoclingComponent) component).setConfiguration((org.apache.camel.component.docling.DoclingConfiguration) value); return true;
            case "contentInBody": getOrCreateConfiguration((DoclingComponent) component).setContentInBody((boolean) value); return true;
            case "doclingServeUrl": getOrCreateConfiguration((DoclingComponent) component).setDoclingServeUrl((java.lang.String) value); return true;
            case "enableOCR": getOrCreateConfiguration((DoclingComponent) component).setEnableOCR((boolean) value); return true;
            case "includeLayoutInfo": getOrCreateConfiguration((DoclingComponent) component).setIncludeLayoutInfo((boolean) value); return true;
            case "lazyStartProducer": ((DoclingComponent) component).setLazyStartProducer((boolean) value); return true;
            case "ocrLanguage": getOrCreateConfiguration((DoclingComponent) component).setOcrLanguage((java.lang.String) value); return true;
            case "operation": getOrCreateConfiguration((DoclingComponent) component).setOperation((org.apache.camel.component.docling.DoclingOperations) value); return true;
            case "outputFormat": getOrCreateConfiguration((DoclingComponent) component).setOutputFormat((java.lang.String) value); return true;
            case "useDoclingServe": getOrCreateConfiguration((DoclingComponent) component).setUseDoclingServe((boolean) value); return true;
            case "apiTimeout": getOrCreateConfiguration((DoclingComponent) component).setApiTimeout((long) value); return true;
            case "asyncPollInterval": getOrCreateConfiguration((DoclingComponent) component).setAsyncPollInterval((long) value); return true;
            case "asyncTimeout": getOrCreateConfiguration((DoclingComponent) component).setAsyncTimeout((long) value); return true;
            case "autowiredEnabled": ((DoclingComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "connectionRequestTimeout": getOrCreateConfiguration((DoclingComponent) component).setConnectionRequestTimeout((int) value); return true;
            case "connectionTimeout": getOrCreateConfiguration((DoclingComponent) component).setConnectionTimeout((int) value); return true;
            case "connectionTimeToLive": getOrCreateConfiguration((DoclingComponent) component).setConnectionTimeToLive((long) value); return true;
            case "convertEndpoint": getOrCreateConfiguration((DoclingComponent) component).setConvertEndpoint((java.lang.String) value); return true;
            case "doclingCommand": getOrCreateConfiguration((DoclingComponent) component).setDoclingCommand((java.lang.String) value); return true;
            case "evictIdleConnections": getOrCreateConfiguration((DoclingComponent) component).setEvictIdleConnections((boolean) value); return true;
            case "maxConnectionsPerRoute": getOrCreateConfiguration((DoclingComponent) component).setMaxConnectionsPerRoute((int) value); return true;
            case "maxIdleTime": getOrCreateConfiguration((DoclingComponent) component).setMaxIdleTime((long) value); return true;
            case "maxTotalConnections": getOrCreateConfiguration((DoclingComponent) component).setMaxTotalConnections((int) value); return true;
            case "processTimeout": getOrCreateConfiguration((DoclingComponent) component).setProcessTimeout((long) value); return true;
            case "socketTimeout": getOrCreateConfiguration((DoclingComponent) component).setSocketTimeout((int) value); return true;
            case "useAsyncMode": getOrCreateConfiguration((DoclingComponent) component).setUseAsyncMode((boolean) value); return true;
            case "validateAfterInactivity": getOrCreateConfiguration((DoclingComponent) component).setValidateAfterInactivity((int) value); return true;
            case "workingDirectory": getOrCreateConfiguration((DoclingComponent) component).setWorkingDirectory((java.lang.String) value); return true;
            case "batchFailOnFirstError": getOrCreateConfiguration((DoclingComponent) component).setBatchFailOnFirstError((boolean) value); return true;
            case "batchParallelism": getOrCreateConfiguration((DoclingComponent) component).setBatchParallelism((int) value); return true;
            case "batchSize": getOrCreateConfiguration((DoclingComponent) component).setBatchSize((int) value); return true;
            case "batchTimeout": getOrCreateConfiguration((DoclingComponent) component).setBatchTimeout((long) value); return true;
            case "splitBatchResults": getOrCreateConfiguration((DoclingComponent) component).setSplitBatchResults((boolean) value); return true;
            case "extractAllMetadata": getOrCreateConfiguration((DoclingComponent) component).setExtractAllMetadata((boolean) value); return true;
            case "includeMetadataInHeaders": getOrCreateConfiguration((DoclingComponent) component).setIncludeMetadataInHeaders((boolean) value); return true;
            case "includeRawMetadata": getOrCreateConfiguration((DoclingComponent) component).setIncludeRawMetadata((boolean) value); return true;
            case "apiKeyHeader": getOrCreateConfiguration((DoclingComponent) component).setApiKeyHeader((java.lang.String) value); return true;
            case "authenticationScheme": getOrCreateConfiguration((DoclingComponent) component).setAuthenticationScheme((org.apache.camel.component.docling.AuthenticationScheme) value); return true;
            case "authenticationToken": getOrCreateConfiguration((DoclingComponent) component).setAuthenticationToken((java.lang.String) value); return true;
            case "maxFileSize": getOrCreateConfiguration((DoclingComponent) component).setMaxFileSize((long) value); return true;
            default: return false;
            }
        }
    }
}