/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.postgres.PostgresActionBuilder;
import org.apache.cayenne.dba.postgres.PostgresByteArrayType;
import org.apache.cayenne.dba.postgres.PostgresMergerFactory;
import org.apache.cayenne.dba.postgres.PostgresPkGenerator;
import org.apache.cayenne.dba.postgres.PostgresQualifierTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresAdapter
extends JdbcAdapter {
    public PostgresAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories);
        this.setSupportsBatchUpdates(true);
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new PostgresActionBuilder(this, node.getEntityResolver()));
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, false));
        map.registerType(new PostgresByteArrayType(true, true));
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int scale, boolean allowNulls) {
        if ("bytea".equalsIgnoreCase(typeName)) {
            type = -4;
        } else if ("oid".equals(typeName)) {
            type = 2004;
        } else if ("text".equalsIgnoreCase(typeName)) {
            type = 2005;
        }
        return super.buildAttribute(name, typeName, type, size, scale, allowNulls);
    }

    @Override
    public String createTable(DbEntity ent) {
        boolean status = ent.getDataMap() != null && ent.getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy context = this.getQuotingStrategy(status);
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ");
        buf.append(context.quoteFullyQualifiedName(ent));
        buf.append(" (");
        Iterator<DbAttribute> it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.", new Object[0]);
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType(), new Object[0]);
            }
            String type = types[0];
            buf.append(context.quoteString(at.getName())).append(' ').append(type);
            if (this.typeSupportsLength(at.getType())) {
                int scale;
                int len = at.getMaxLength();
                int n = scale = TypesMapping.isDecimal(at.getType()) && at.getType() != 6 ? at.getScale() : -1;
                if (scale > len) {
                    scale = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (scale >= 0) {
                        buf.append(", ").append(scale);
                    }
                    buf.append(')');
                }
            }
            if (at.isMandatory()) {
                buf.append(" NOT NULL");
                continue;
            }
            buf.append(" NULL");
        }
        Iterator<DbAttribute> pkit = ent.getPrimaryKeys().iterator();
        if (pkit.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    buf.append(", ");
                }
                DbAttribute at = pkit.next();
                buf.append(context.quoteString(at.getName()));
            }
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public boolean typeSupportsLength(int type) {
        String[] externalTypes = this.externalTypesForJdbcType(type);
        if (externalTypes != null && externalTypes.length > 0) {
            for (String externalType : externalTypes) {
                if (!"bytea".equalsIgnoreCase(externalType)) continue;
                return false;
            }
        }
        return super.typeSupportsLength(type);
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        QuotingStrategy context = this.getQuotingStrategy(table.getDataMap().isQuotingSQLIdentifiers());
        StringBuffer buf = new StringBuffer("DROP TABLE ");
        buf.append(context.quoteFullyQualifiedName(table));
        buf.append(" CASCADE");
        return Collections.singleton(buf.toString());
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        PostgresQualifierTranslator translator = new PostgresQualifierTranslator(queryAssembler);
        translator.setCaseInsensitive(this.caseInsensitiveCollations);
        return translator;
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new PostgresPkGenerator(this);
    }

    @Override
    public MergerFactory mergerFactory() {
        return new PostgresMergerFactory();
    }
}

