/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlite;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.SQLTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SQLiteSQLTemplateAction
extends SQLTemplateAction {
    public SQLiteSQLTemplateAction(SQLTemplate query, JdbcAdapter adapter, EntityResolver resolver) {
        super(query, adapter, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(Connection connection, OperationObserver callback, SQLStatement compiled, Collection<Number> updateCounts) throws SQLException, Exception {
        block9: {
            String sql = compiled.getSql().trim();
            boolean select = sql.length() > "SELECT".length() && sql.substring(0, "SELECT".length()).equalsIgnoreCase("SELECT");
            long t1 = System.currentTimeMillis();
            boolean iteratedResult = callback.isIteratedResult();
            PreparedStatement statement = connection.prepareStatement(compiled.getSql());
            try {
                this.bind(statement, compiled.getBindings());
                if (select) {
                    ResultSet resultSet = statement.executeQuery();
                    try {
                        this.processSelectResult(compiled, connection, statement, resultSet, callback, t1);
                        break block9;
                    }
                    finally {
                        if (!iteratedResult) {
                            resultSet.close();
                        }
                    }
                }
                int updateCount = statement.executeUpdate();
                updateCounts.add(updateCount);
                this.adapter.getJdbcEventLogger().logUpdateCount(updateCount);
            }
            finally {
                if (!iteratedResult) {
                    statement.close();
                }
            }
        }
    }
}

