/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ModelerPreferences;
import org.apache.cayenne.modeler.action.NewProjectAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.event.RecentFileListListener;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class WelcomeScreen
extends JPanel
implements RecentFileListListener {
    private static final Color TOP_GRADIENT = new Color(153, 153, 153);
    private static final Color BOTTOM_GRADIENT = new Color(230, 230, 230);
    private JList recentsList;

    public WelcomeScreen() {
        this.initView();
    }

    protected void initView() {
        this.setLayout(new GridBagLayout());
        ImageIcon welcome = ModelerUtil.buildIcon("welcome.jpg");
        JLabel imageLabel = new JLabel(welcome);
        ImageIcon newOutIcon = ModelerUtil.buildIcon("icon-welcome-new.png");
        ImageIcon newOverIcon = ModelerUtil.buildIcon("icon-welcome-new-over.png");
        ImageIcon openOutIcon = ModelerUtil.buildIcon("icon-welcome-open.png");
        ImageIcon openOverIcon = ModelerUtil.buildIcon("icon-welcome-open-over.png");
        JPanel buttonsPane = new JPanel(null);
        buttonsPane.setPreferredSize(new Dimension(300, 30));
        buttonsPane.setOpaque(false);
        JButton newButton = this.createButton(newOutIcon, newOverIcon);
        newButton.addActionListener(Application.getInstance().getActionManager().getAction(NewProjectAction.class));
        JLabel newLabel = new JLabel(NewProjectAction.getActionName(), 0);
        JButton openButton = this.createButton(openOutIcon, openOverIcon);
        openButton.addActionListener(Application.getInstance().getActionManager().getAction(OpenProjectAction.class));
        JLabel openLabel = new JLabel(OpenProjectAction.getActionName(), 0);
        imageLabel.setLayout(new BorderLayout());
        newButton.setLocation(10, 130);
        buttonsPane.add(newButton);
        newLabel.setLocation(newButton.getX() + newButton.getWidth() / 2 - newLabel.getPreferredSize().width / 2, newButton.getY() + newButton.getHeight());
        newLabel.setSize(newLabel.getPreferredSize());
        buttonsPane.add(newLabel);
        openButton.setLocation(120, newButton.getY());
        buttonsPane.add(openButton);
        openLabel.setLocation(openButton.getX() + openButton.getWidth() / 2 - openLabel.getPreferredSize().width / 2, openButton.getY() + openButton.getHeight());
        openLabel.setSize(openLabel.getPreferredSize());
        buttonsPane.add(openLabel);
        JLabel recents = new JLabel("Recent Projects:");
        recents.setLocation(207, newButton.getY());
        recents.setSize(recents.getPreferredSize());
        recents.setHorizontalTextPosition(10);
        buttonsPane.add(recents);
        this.recentsList = new JList();
        this.recentsList.setOpaque(false);
        this.recentsList.setLocation(recents.getX(), recents.getY() + 2 * recents.getHeight());
        this.recentsList.setSize(welcome.getIconWidth() - this.recentsList.getX() - 1, welcome.getIconHeight() - this.recentsList.getY());
        this.recentsList.setCellRenderer(new RecentFileListRenderer(this.recentsList));
        buttonsPane.add(this.recentsList);
        imageLabel.add(buttonsPane);
        this.add(imageLabel);
    }

    private JButton createButton(Icon outIcon, Icon overIcon) {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.setPressedIcon(overIcon);
        button.setRolloverIcon(overIcon);
        button.setIcon(outIcon);
        button.setSize(outIcon.getIconWidth(), outIcon.getIconHeight());
        return button;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(new GradientPaint(0.0f, 0.0f, TOP_GRADIENT, 0.0f, this.getHeight(), BOTTOM_GRADIENT));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.dispose();
    }

    public void recentFileListChanged() {
        final List<String> arr = ModelerPreferences.getLastProjFiles();
        this.recentsList.setModel(new AbstractListModel(){

            public int getSize() {
                return arr.size();
            }

            public Object getElementAt(int i) {
                return arr.get(i);
            }
        });
    }

    class RecentFileListRenderer
    extends DefaultListCellRenderer
    implements MouseInputListener {
        final Color ROLLOVER_BACKGROUND = Color.RED;
        final Color ROLLOVER_FOREGROUND = Color.WHITE;
        private final JList list;
        private int rolloverRow;

        public RecentFileListRenderer(JList list) {
            list.addMouseListener(this);
            list.addMouseMotionListener(this);
            this.list = list;
            this.rolloverRow = -1;
            this.setHorizontalTextPosition(10);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, false, false);
            if (this.rolloverRow == index) {
                this.setOpaque(true);
                this.setForeground(this.ROLLOVER_FOREGROUND);
                this.setBackground(this.ROLLOVER_BACKGROUND);
                this.setToolTipText(this.getText());
            } else {
                this.setOpaque(false);
            }
            return this;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        public void mouseExited(MouseEvent e) {
            this.rolloverRow = -1;
            this.list.repaint();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && this.rolloverRow != -1) {
                File file = new File((String)this.list.getModel().getElementAt(this.rolloverRow));
                Application.getInstance().getActionManager().getAction(OpenProjectAction.class).performAction(new ActionEvent(file, 0, null));
                this.rolloverRow = -1;
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            int newRow = this.list.getModel().getSize() > 0 && !this.list.getCellBounds(0, this.list.getModel().getSize() - 1).contains(e.getPoint()) ? -1 : this.list.locationToIndex(e.getPoint());
            if (this.rolloverRow != newRow) {
                this.rolloverRow = newRow;
                this.list.repaint();
            }
        }
    }
}

