/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class SQLTemplateValidator
extends ConfigurationNodeValidator {
    SQLTemplateValidator() {
    }

    void validate(SQLTemplate query, ValidationResult validationResult) {
        this.validateName(query, validationResult);
        this.validateRoot(query, validationResult);
        this.validateDefaultSQL(query, validationResult);
    }

    void validateDefaultSQL(SQLTemplate query, ValidationResult validationResult) {
        if (Util.isEmptyString(query.getDefaultTemplate())) {
            for (String key : query.getTemplateKeys()) {
                if (Util.isEmptyString(query.getCustomTemplate(key))) continue;
                return;
            }
            this.addFailure(validationResult, query, "SQLTemplate query '%s' has no default SQL template", query.getName());
        }
    }

    void validateRoot(SQLTemplate query, ValidationResult validationResult) {
        DataMap map = query.getDataMap();
        if (query.getRoot() == null && map != null) {
            this.addFailure(validationResult, query, "SQLTemplate query '%s' has no root", query.getName());
        }
    }

    void validateName(SQLTemplate query, ValidationResult validationResult) {
        String name = query.getName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, query, "Unnamed SQLTemplate", new Object[0]);
            return;
        }
        DataMap map = query.getDataMap();
        if (map == null) {
            return;
        }
        for (Query otherQuery : map.getQueries()) {
            if (otherQuery == query || !name.equals(otherQuery.getName())) continue;
            this.addFailure(validationResult, query, "Duplicate query name: %s", name);
            break;
        }
    }
}

