/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.ExtendedEnumeration;
import org.apache.cayenne.access.jdbc.ParameterBinding;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.log.CommonsJdbcEventLogger;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.util.IDUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class QueryLogger {
    private static final int TRIM_VALUES_THRESHOLD = 30;
    private static JdbcEventLogger logger = new CommonsJdbcEventLogger();

    public static void setLogger(JdbcEventLogger logger) {
        QueryLogger.logger = logger;
    }

    public static JdbcEventLogger getLogger() {
        return logger;
    }

    public static void sqlLiteralForObject(StringBuffer buffer, Object object) {
        if (object == null) {
            buffer.append("NULL");
        } else if (object instanceof String) {
            buffer.append('\'');
            String literal = (String)object;
            if (literal.length() > 30) {
                literal = literal.substring(0, 30) + "...";
            }
            int curPos = 0;
            int endPos = 0;
            while ((endPos = literal.indexOf(39, curPos)) >= 0) {
                buffer.append(literal.substring(curPos, endPos + 1)).append('\'');
                curPos = endPos + 1;
            }
            if (curPos < literal.length()) {
                buffer.append(literal.substring(curPos));
            }
            buffer.append('\'');
        } else if (object instanceof Byte) {
            IDUtil.appendFormattedByte(buffer, (Byte)object);
        } else if (object instanceof Number) {
            buffer.append(object);
        } else if (object instanceof Date) {
            buffer.append('\'').append(object).append('\'');
        } else if (object instanceof Time) {
            buffer.append('\'').append(object).append('\'');
        } else if (object instanceof java.util.Date) {
            long time = ((java.util.Date)object).getTime();
            buffer.append('\'').append(new Timestamp(time)).append('\'');
        } else if (object instanceof Calendar) {
            long time = ((Calendar)object).getTimeInMillis();
            buffer.append(object.getClass().getName()).append('(').append(new Timestamp(time)).append(')');
        } else if (object instanceof Character) {
            buffer.append(((Character)object).charValue());
        } else if (object instanceof Boolean) {
            buffer.append('\'').append(object).append('\'');
        } else if (object instanceof Enum) {
            buffer.append(((Enum)object).name()).append("=");
            if (object instanceof ExtendedEnumeration) {
                Object value = ((ExtendedEnumeration)object).getDatabaseValue();
                if (value instanceof String) {
                    buffer.append("'");
                }
                buffer.append(value);
                if (value instanceof String) {
                    buffer.append("'");
                }
            } else {
                buffer.append(((Enum)object).ordinal());
            }
        } else if (object instanceof ParameterBinding) {
            QueryLogger.sqlLiteralForObject(buffer, ((ParameterBinding)object).getValue());
        } else if (object.getClass().isArray()) {
            buffer.append("< ");
            int len = Array.getLength(object);
            boolean trimming = false;
            if (len > 30) {
                len = 30;
                trimming = true;
            }
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                QueryLogger.sqlLiteralForObject(buffer, Array.get(object, i));
            }
            if (trimming) {
                buffer.append("...");
            }
            buffer.append('>');
        } else {
            buffer.append(object.getClass().getName()).append("@").append(System.identityHashCode(object));
        }
    }

    public static void log(String message) {
        logger.log(message);
    }

    public static void logConnect(String dataSource) {
        logger.logConnect(dataSource);
    }

    public static void logConnect(String url, String userName, String password) {
        logger.logConnect(url, userName, password);
    }

    public static void logPoolCreated(DataSourceInfo dsi) {
        logger.logPoolCreated(dsi);
    }

    public static void logConnectSuccess() {
        logger.logConnectSuccess();
    }

    public static void logConnectFailure(Throwable th) {
        logger.logConnectFailure(th);
    }

    public static void logGeneratedKey(DbAttribute attribute, Object value) {
        logger.logGeneratedKey(attribute, value);
    }

    public static void logQuery(String queryStr, List<?> params) {
        logger.logQuery(queryStr, params);
    }

    public static void logQuery(String queryStr, List<DbAttribute> attrs, List<?> params, long time) {
        logger.logQuery(queryStr, attrs, params, time);
    }

    public static void logQueryParameters(String label, List<DbAttribute> attrs, List<Object> parameters, boolean isInserting) {
        logger.logQueryParameters(label, attrs, parameters, isInserting);
    }

    public static void logSelectCount(int count) {
        QueryLogger.logSelectCount(count, -1L);
    }

    public static void logSelectCount(int count, long time) {
        logger.logSelectCount(count, time);
    }

    public static void logUpdateCount(int count) {
        logger.logUpdateCount(count);
    }

    public static void logBeginTransaction(String transactionLabel) {
        logger.logBeginTransaction(transactionLabel);
    }

    public static void logCommitTransaction(String transactionLabel) {
        logger.logCommitTransaction(transactionLabel);
    }

    public static void logRollbackTransaction(String transactionLabel) {
        logger.logRollbackTransaction(transactionLabel);
    }

    public static void logQueryError(Throwable th) {
        logger.logQueryError(th);
    }

    public static void logQueryStart(int count) {
        if (QueryLogger.isLoggable()) {
            String countStr = count == 1 ? "--- will run 1 query." : "--- will run " + count + " queries.";
            logger.log(countStr);
        }
    }

    public static boolean isLoggable() {
        return logger.isLoggable();
    }
}

