/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetPrimaryKeyToDb
extends AbstractToDbToken.Entity {
    private Collection<DbAttribute> primaryKeyOriginal;
    private Collection<DbAttribute> primaryKeyNew;
    private String detectedPrimaryKeyName;

    public SetPrimaryKeyToDb(DbEntity entity, Collection<DbAttribute> primaryKeyOriginal, Collection<DbAttribute> primaryKeyNew, String detectedPrimaryKeyName) {
        super(entity);
        this.primaryKeyOriginal = primaryKeyOriginal;
        this.primaryKeyNew = primaryKeyNew;
        this.detectedPrimaryKeyName = detectedPrimaryKeyName;
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        ArrayList<String> sqls = new ArrayList<String>();
        if (!this.primaryKeyOriginal.isEmpty()) {
            this.appendDropOriginalPrimaryKeySQL(adapter, sqls);
        }
        this.appendAddNewPrimaryKeySQL(adapter, sqls);
        return sqls;
    }

    protected void appendDropOriginalPrimaryKeySQL(DbAdapter adapter, List<String> sqls) {
        if (this.detectedPrimaryKeyName == null) {
            return;
        }
        sqls.add("ALTER TABLE " + this.getQuotingStrategy(adapter).quoteFullyQualifiedName(this.getEntity()) + " DROP CONSTRAINT " + this.detectedPrimaryKeyName);
    }

    protected void appendAddNewPrimaryKeySQL(DbAdapter adapter, List<String> sqls) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(this.getQuotingStrategy(adapter).quoteFullyQualifiedName(this.getEntity()));
        sql.append(" ADD PRIMARY KEY (");
        Iterator<DbAttribute> it = this.primaryKeyNew.iterator();
        while (it.hasNext()) {
            sql.append(this.getQuotingStrategy(adapter).quoteString(it.next().getName()));
            if (!it.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(")");
        sqls.add(sql.toString());
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createSetPrimaryKeyToModel(this.getEntity(), this.primaryKeyNew, this.primaryKeyOriginal, this.detectedPrimaryKeyName);
    }

    @Override
    public String getTokenName() {
        return "Set Primary Key";
    }
}

