/*
 * Decompiled with CFR 0.152.
 */
package foundrylogic.vpp;

import foundrylogic.vpp.VPPConfig;
import foundrylogic.vpp.VPPCopyTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VPPFilter
extends BaseParamFilterReader
implements ChainableReader {
    private VPPConfig vppConfig;
    private boolean preprocessed;

    public VPPFilter() {
    }

    public VPPFilter(Reader reader) {
        super(reader);
    }

    protected VPPFilter(Reader reader, VPPConfig vPPConfig) {
        this(reader);
        this.vppConfig = vPPConfig;
        this.setInitialized(true);
    }

    public boolean getPreprocessed() {
        return this.preprocessed;
    }

    public void setPreprocessed(boolean bl) {
        this.preprocessed = bl;
    }

    public Reader chain(Reader reader) {
        return new VPPFilter(reader, this.vppConfig);
    }

    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
        }
        if (!this.getPreprocessed()) {
            this.preprocess();
        }
        return super.read();
    }

    public boolean ready() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
        }
        if (!this.getPreprocessed()) {
            this.preprocess();
        }
        return super.ready();
    }

    public int read(char[] cArray) throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
        }
        if (!this.getPreprocessed()) {
            this.preprocess();
        }
        return super.read(cArray);
    }

    protected void initialize() {
        if (this.vppConfig == null) {
            Parameter[] parameterArray = this.getParameters();
            if (parameterArray != null) {
                for (int i = 0; i < parameterArray.length; ++i) {
                    Parameter parameter = parameterArray[i];
                    if (parameter.getType().equals("config") && parameter.getName().equals("refid")) {
                        Object object = this.getProject().getReference(parameter.getValue());
                        if (object == null || !(object instanceof VPPConfig)) continue;
                        this.vppConfig = (VPPConfig)((Object)object);
                        continue;
                    }
                    throw new BuildException("unknown parameter type '" + parameter.getType() + "' or name '" + parameter.getName() + "'");
                }
            }
            if (this.vppConfig == null) {
                this.vppConfig = VPPConfig.getDefaultConfig(this.getProject());
            }
        }
        this.setInitialized(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preprocess() throws IOException {
        try {
            Object object;
            VelocityEngine velocityEngine = this.vppConfig.getVelocityEngine();
            String string = (String)velocityEngine.getProperty("input.encoding");
            File file = null;
            Writer writer = null;
            boolean bl = this.vppConfig.isUseTempFile();
            if (bl) {
                object = this.vppConfig.getTempDir();
                if (!((File)object).exists()) {
                    ((File)object).mkdirs();
                }
                file = this.vppConfig.getFileUtils().createTempFile("out", "vpp", (File)object);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), string);
            } else {
                writer = new StringWriter();
            }
            try {
                object = new VelocityContext(this.vppConfig.getVelocityContext());
                this.vppConfig.getVelocityEngine().evaluate((Context)object, writer, "vpp", this.in);
            }
            finally {
                writer.close();
            }
            if (bl) {
                this.in = new InputStreamReader((InputStream)new FileInputStream(file), string);
            } else {
                object = writer.toString();
                this.in = new StringReader((String)object);
            }
            this.setPreprocessed(true);
        }
        catch (Exception exception) {
            VPPCopyTool vPPCopyTool = (VPPCopyTool)this.vppConfig.getVelocityContext().get("vpp");
            String string = "<stream>";
            if (vPPCopyTool != null) {
                string = vPPCopyTool.getSourceName();
            }
            BuildException buildException = new BuildException("error in '" + string + "': " + exception.getMessage());
            buildException.setStackTrace(exception.getStackTrace());
            throw buildException;
        }
    }

    public void addConfiguredConfig(VPPConfig vPPConfig) {
        this.vppConfig = vPPConfig;
    }

    public VPPConfig getConfig() {
        return this.vppConfig;
    }
}

