/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;

public class DbImportModel
extends DefaultTreeModel {
    private DbImportTree dbSchemaTree;
    private boolean canBeCleaned;

    DbImportModel(TreeNode root) {
        super(root);
    }

    private void clearReverseEngineering(ReverseEngineering reverseEngineering) {
        reverseEngineering.getSchemas().clear();
        reverseEngineering.getCatalogs().clear();
        reverseEngineering.getIncludeTables().clear();
        reverseEngineering.getExcludeTables().clear();
        reverseEngineering.getIncludeColumns().clear();
        reverseEngineering.getExcludeColumns().clear();
        reverseEngineering.getIncludeProcedures().clear();
        reverseEngineering.getExcludeProcedures().clear();
    }

    private void preprocessTree() {
        DbImportTreeNode rootNode = (DbImportTreeNode)this.getRoot();
        if (rootNode.getChildCount() == 0) {
            ReverseEngineering reverseEngineering = (ReverseEngineering)rootNode.getUserObject();
            if (this.canBeCleaned) {
                this.clearReverseEngineering(reverseEngineering);
            }
            rootNode.add(new DbImportTreeNode("Configuration is empty."));
        }
    }

    @Override
    public void reload(TreeNode node) {
        this.preprocessTree();
        super.reload(node);
        this.dbSchemaTree.repaint();
    }

    public void setDbSchemaTree(DbImportTree dbSchemaTree) {
        this.dbSchemaTree = dbSchemaTree;
    }

    public void setCanBeCleaned(boolean canBeCleaned) {
        this.canBeCleaned = canBeCleaned;
    }
}

