/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.ashwood.SortWeight;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;

public class WeightedAshwoodEntitySorter
extends AshwoodEntitySorter {
    private Comparator<DbEntity> weightedDbEntityComparator = new WeightedDbEntityComparator();
    private Comparator<ObjEntity> weightedObjEntityComparator = new WeightedObjEntityComparator();
    protected Map<DbEntity, Integer> entityWeights = Collections.emptyMap();

    @Override
    protected void doIndexSorter() {
        super.doIndexSorter();
        this.entityWeights = new HashMap<DbEntity, Integer>();
        for (ObjEntity entity : this.entityResolver.getObjEntities()) {
            this.addWeightForEntity(entity);
        }
    }

    protected void addWeightForEntity(ObjEntity entity) {
        Class<?> type = this.entityResolver.getClassDescriptor(entity.getName()).getObjectClass();
        SortWeight weight = type.getAnnotation(SortWeight.class);
        if (weight != null) {
            this.entityWeights.put(entity.getDbEntity(), weight.value());
        }
    }

    @Override
    protected Comparator<DbEntity> getDbEntityComparator(boolean dependantFirst) {
        Comparator<DbEntity> c = this.weightedDbEntityComparator;
        if (dependantFirst) {
            c = c.reversed();
        }
        return c;
    }

    @Override
    protected Comparator<ObjEntity> getObjEntityComparator(boolean dependantFirst) {
        Comparator<ObjEntity> c = this.weightedObjEntityComparator;
        if (dependantFirst) {
            c = c.reversed();
        }
        return c;
    }

    private int getWeight(DbEntity e) {
        Integer w = this.entityWeights.get(e);
        return w != null ? w : 1;
    }

    private final class WeightedDbEntityComparator
    implements Comparator<DbEntity> {
        private WeightedDbEntityComparator() {
        }

        @Override
        public int compare(DbEntity t1, DbEntity t2) {
            if (t1 == t2) {
                return 0;
            }
            int delta = WeightedAshwoodEntitySorter.this.getWeight(t1) - WeightedAshwoodEntitySorter.this.getWeight(t2);
            return delta != 0 ? delta : WeightedAshwoodEntitySorter.this.dbEntityComparator.compare(t1, t2);
        }
    }

    private final class WeightedObjEntityComparator
    implements Comparator<ObjEntity> {
        private WeightedObjEntityComparator() {
        }

        @Override
        public int compare(ObjEntity o1, ObjEntity o2) {
            if (o1 == o2) {
                return 0;
            }
            DbEntity t1 = o1.getDbEntity();
            DbEntity t2 = o2.getDbEntity();
            return WeightedAshwoodEntitySorter.this.weightedDbEntityComparator.compare(t1, t2);
        }
    }
}

