/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.components.textpane;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class UnderlineHighlighterForText
extends DefaultHighlighter {
    protected static final Highlighter.HighlightPainter sharedPainter = new UnderlineHighlightPainter(null);
    protected Highlighter.HighlightPainter painter;

    public UnderlineHighlighterForText(Color c) {
        this.painter = c == null ? sharedPainter : new UnderlineHighlightPainter(c);
    }

    public Object addHighlight(int p0, int p1) throws BadLocationException {
        return this.addHighlight(p0, p1, this.painter);
    }

    public void setDrawsLayeredHighlights(boolean newValue) {
        if (!newValue) {
            throw new IllegalArgumentException("UnderlineHighlighterForArea only draws layered highlights");
        }
        super.setDrawsLayeredHighlights(true);
    }

    public static class UnderlineHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        protected Color color;

        public UnderlineHighlightPainter(Color c) {
            this.color = c;
        }

        public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        }

        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            g.setColor(this.color == null ? c.getSelectionColor() : this.color);
            Rectangle alloc = null;
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    alloc = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
                catch (BadLocationException e) {
                    return null;
                }
            }
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int baseline = alloc.y + alloc.height - fm.getDescent() + 1;
            int end = alloc.x + alloc.width - 1;
            for (int i = alloc.x; i < end; i += 4) {
                g.drawLine(i, baseline, i + 2, baseline);
                g.drawLine(i, baseline + 1, i + 2, baseline + 1);
            }
            return alloc;
        }
    }
}

