/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import javax.sql.DataSource;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DBCPDataSourceBuilder;
import org.apache.cayenne.conf.DBCPDataSourceProperties;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.conf.ResourceFinder;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBCPDataSourceFactory
implements DataSourceFactory {
    private static final Log logger = LogFactory.getLog(DBCPDataSourceFactory.class);
    public static final String PROPERTY_PREFIX = "cayenne.dbcp.";
    public static final String PS_PROPERTY_PREFIX = "cayenne.dbcp.ps.";
    protected Configuration parentConfiguration;

    public void initializeWithParentConfiguration(Configuration parentConfiguration) {
        this.parentConfiguration = parentConfiguration;
    }

    public DataSource getDataSource(String location) throws Exception {
        ResourceFinder resourceFinder;
        if (this.parentConfiguration != null) {
            resourceFinder = this.parentConfiguration.getResourceFinder();
        } else {
            ResourceLocator resourceLocator = new ResourceLocator();
            resourceLocator.setSkipAbsolutePath(false);
            resourceLocator.setSkipHomeDirectory(true);
            resourceLocator.setSkipClasspath(false);
            resourceLocator.setSkipCurrentDirectory(false);
            resourceFinder = resourceLocator;
        }
        DBCPDataSourceProperties properties = new DBCPDataSourceProperties(resourceFinder, location);
        if (logger.isDebugEnabled()) {
            logger.debug("DBCP Properties: " + properties.getProperties());
        }
        DBCPDataSourceBuilder builder = new DBCPDataSourceBuilder(properties);
        return builder.createDataSource();
    }
}

