/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.DbJoinTableModel;
import org.apache.cayenne.modeler.undo.RelationshipUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneDialog;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneWidgetFactory;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.util.Util;

public class ResolveDbRelationshipDialog
extends CayenneDialog {
    protected DbRelationship relationship;
    protected DbRelationship reverseRelationship;
    protected JTextField name;
    protected JTextField reverseName;
    protected CayenneTable table;
    protected JButton addButton;
    protected JButton removeButton;
    protected JButton saveButton;
    protected JButton cancelButton;
    private boolean cancelPressed;
    private RelationshipUndoableEdit undo;
    private boolean editable = true;

    public ResolveDbRelationshipDialog(DbRelationship relationship) {
        this(relationship, true);
    }

    public ResolveDbRelationshipDialog(DbRelationship relationship, boolean editable) {
        super(Application.getFrame(), "", true);
        this.editable = editable;
        this.initView();
        this.initController();
        this.initWithModel(relationship);
        this.undo = new RelationshipUndoableEdit(relationship);
        this.pack();
        this.centerWindow();
    }

    private void initView() {
        this.name = CayenneWidgetFactory.createTextField(25);
        this.reverseName = CayenneWidgetFactory.createTextField(25);
        this.addButton = new JButton("Add");
        this.addButton.setEnabled(this.editable);
        this.removeButton = new JButton("Remove");
        this.removeButton.setEnabled(this.editable);
        this.saveButton = new JButton("Done");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setEnabled(this.editable);
        this.table = new AttributeTable();
        this.table.getSelectionModel().setSelectionMode(0);
        this.getContentPane().setLayout(new BorderLayout());
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("right:max(50dlu;pref), 3dlu, fill:min(150dlu;pref), 3dlu, fill:min(50dlu;pref)", "p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, top:14dlu, 3dlu, top:p:grow"));
        builder.setDefaultDialogBorder();
        builder.addSeparator("DbRelationship Information", cc.xywh(1, 1, 5, 1));
        builder.addLabel("Relationship:", cc.xy(1, 3));
        builder.add((Component)this.name, cc.xywh(3, 3, 1, 1));
        builder.addLabel("Reverse Relationship", cc.xy(1, 5));
        builder.add((Component)this.reverseName, cc.xywh(3, 5, 1, 1));
        builder.addSeparator("Joins", cc.xywh(1, 7, 5, 1));
        builder.add((Component)new JScrollPane(this.table), cc.xywh(1, 9, 3, 3, "fill, fill"));
        JPanel buttons = new JPanel(new FlowLayout(3));
        buttons.add(this.addButton);
        buttons.add(this.removeButton);
        builder.add((Component)buttons, cc.xywh(5, 9, 1, 3));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.getContentPane().add((Component)PanelFactory.createButtonPanel(new JButton[]{this.saveButton, this.cancelButton}), "South");
    }

    private void initWithModel(DbRelationship aRelationship) {
        if (aRelationship.getSourceEntity() == null) {
            throw new CayenneRuntimeException("Null source entity: " + aRelationship);
        }
        if (aRelationship.getTargetEntity() == null) {
            throw new CayenneRuntimeException("Null target entity: " + aRelationship);
        }
        if (aRelationship.getSourceEntity().getDataMap() == null) {
            throw new CayenneRuntimeException("Null DataMap: " + aRelationship.getSourceEntity());
        }
        this.relationship = aRelationship;
        this.reverseRelationship = this.relationship.getReverseRelationship();
        this.setTitle("DbRelationship Info: " + this.relationship.getSourceEntity().getName() + " to " + this.relationship.getTargetEntityName());
        this.table.setModel(new DbJoinTableModel(this.relationship, this.getMediator(), this, true));
        TableColumn sourceColumn = this.table.getColumnModel().getColumn(0);
        sourceColumn.setMinWidth(150);
        JComboBox comboBox = CayenneWidgetFactory.createComboBox(ModelerUtil.getDbAttributeNames(this.getMediator(), (DbEntity)this.relationship.getSourceEntity()), true);
        AutoCompletion.enable(comboBox);
        sourceColumn.setCellEditor(CayenneWidgetFactory.createCellEditor(comboBox));
        TableColumn targetColumn = this.table.getColumnModel().getColumn(1);
        targetColumn.setMinWidth(150);
        comboBox = CayenneWidgetFactory.createComboBox(ModelerUtil.getDbAttributeNames(this.getMediator(), (DbEntity)this.relationship.getTargetEntity()), true);
        AutoCompletion.enable(comboBox);
        targetColumn.setCellEditor(CayenneWidgetFactory.createCellEditor(comboBox));
        if (this.reverseRelationship != null) {
            this.reverseName.setText(this.reverseRelationship.getName());
        }
        this.name.setText(this.relationship.getName());
    }

    private void initController() {
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbJoinTableModel model = (DbJoinTableModel)ResolveDbRelationshipDialog.this.table.getModel();
                DbJoin join = new DbJoin(ResolveDbRelationshipDialog.this.relationship);
                model.addRow(join);
                ResolveDbRelationshipDialog.this.undo.addDbJoinAddUndo(join);
                ResolveDbRelationshipDialog.this.table.select(model.getRowCount() - 1);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DbJoinTableModel model = (DbJoinTableModel)ResolveDbRelationshipDialog.this.table.getModel();
                ResolveDbRelationshipDialog.this.stopEditing();
                int row = ResolveDbRelationshipDialog.this.table.getSelectedRow();
                DbJoin join = model.getJoin(row);
                ResolveDbRelationshipDialog.this.undo.addDbJoinRemoveUndo(join);
                model.removeRow(join);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResolveDbRelationshipDialog.this.cancelPressed = false;
                if (ResolveDbRelationshipDialog.this.editable) {
                    ResolveDbRelationshipDialog.this.save();
                }
                ResolveDbRelationshipDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResolveDbRelationshipDialog.this.cancelPressed = true;
                ResolveDbRelationshipDialog.this.setVisible(false);
            }
        });
    }

    public boolean isCancelPressed() {
        return this.cancelPressed;
    }

    private void stopEditing() {
        int col_index = this.table.getEditingColumn();
        if (col_index >= 0) {
            TableColumn col = this.table.getColumnModel().getColumn(col_index);
            col.getCellEditor().stopCellEditing();
        }
    }

    private void save() {
        String oldName;
        DbJoinTableModel model;
        boolean updatingReverse;
        String sourceEntityName = this.name.getText();
        if (sourceEntityName.length() == 0) {
            sourceEntityName = null;
        }
        if (sourceEntityName == null) {
            sourceEntityName = NamedObjectFactory.createName(DbRelationship.class, this.relationship.getSourceEntity());
        }
        if (!this.validateName(this.relationship.getSourceEntity(), this.relationship, sourceEntityName)) {
            return;
        }
        String targetEntityName = this.reverseName.getText().trim();
        if (targetEntityName.length() == 0) {
            targetEntityName = null;
        }
        if (targetEntityName == null) {
            targetEntityName = NamedObjectFactory.createName(DbRelationship.class, this.relationship.getTargetEntity());
        }
        boolean bl = updatingReverse = (model = (DbJoinTableModel)this.table.getModel()).getObjectList().size() > 0;
        if (updatingReverse && !this.validateName(this.relationship.getTargetEntity(), this.reverseRelationship, targetEntityName)) {
            return;
        }
        if (!Util.nullSafeEquals(sourceEntityName, this.relationship.getName())) {
            oldName = this.relationship.getName();
            ProjectUtil.setRelationshipName(this.relationship.getSourceEntity(), this.relationship, sourceEntityName);
            this.undo.addNameUndo(this.relationship, oldName, sourceEntityName);
            this.getMediator().fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)this.relationship, this.relationship.getSourceEntity(), oldName));
        }
        model.commit();
        if (this.relationship.isToDependentPK() && !this.relationship.isValidForDepPk()) {
            this.relationship.setToDependentPK(false);
        }
        if (updatingReverse) {
            if (this.reverseRelationship == null) {
                this.reverseRelationship = new DbRelationship(targetEntityName);
                this.reverseRelationship.setSourceEntity(this.relationship.getTargetEntity());
                this.reverseRelationship.setTargetEntity(this.relationship.getSourceEntity());
                this.reverseRelationship.setToMany(!this.relationship.isToMany());
                this.relationship.getTargetEntity().addRelationship(this.reverseRelationship);
                if (this.relationship.getSourceEntity() == this.relationship.getTargetEntity()) {
                    this.getMediator().fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)this.reverseRelationship, this.reverseRelationship.getSourceEntity(), 2));
                }
            } else if (!Util.nullSafeEquals(targetEntityName, this.reverseRelationship.getName())) {
                oldName = this.reverseRelationship.getName();
                ProjectUtil.setRelationshipName(this.reverseRelationship.getSourceEntity(), this.reverseRelationship, targetEntityName);
                this.undo.addNameUndo(this.reverseRelationship, oldName, targetEntityName);
                this.getMediator().fireDbRelationshipEvent(new RelationshipEvent((Object)this, (Relationship)this.reverseRelationship, this.reverseRelationship.getSourceEntity(), oldName));
            }
            Collection reverseJoins = this.getReverseJoins();
            this.reverseRelationship.setJoins(reverseJoins);
            if (!this.relationship.isToDependentPK() && this.reverseRelationship.isValidForDepPk()) {
                this.reverseRelationship.setToDependentPK(true);
            }
        }
        Application.getInstance().getUndoManager().addEdit(this.undo);
        this.getMediator().fireDbRelationshipEvent(new RelationshipEvent((Object)this, this.relationship, this.relationship.getSourceEntity()));
    }

    private boolean validateName(Entity entity, Relationship aRelationship, String newName) {
        Relationship existing = entity.getRelationship(newName);
        if (existing != null && (aRelationship == null || aRelationship != existing)) {
            JOptionPane.showMessageDialog(this, "There is an existing relationship named \"" + newName + "\". Select a different name.");
            return false;
        }
        return true;
    }

    private Collection getReverseJoins() {
        List<DbJoin> joins = this.relationship.getJoins();
        if (joins == null || joins.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DbJoin> reverseJoins = new ArrayList<DbJoin>(joins.size());
        for (DbJoin pair : joins) {
            DbJoin reverseJoin = pair.createReverseJoin();
            reverseJoin.setRelationship(this.reverseRelationship);
            reverseJoins.add(reverseJoin);
        }
        return reverseJoins;
    }

    final class AttributeTable
    extends CayenneTable {
        final Dimension preferredSize = new Dimension(203, 100);

        AttributeTable() {
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.preferredSize;
        }
    }
}

