/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.objectstyle.ashwood.graph.Algorithm;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;

public class IndegreeTopologicalSort
extends Algorithm {
    private Digraph digraph;
    private LinkedList vertices = new LinkedList();
    private Map inDegrees = new HashMap();
    private ListIterator current;

    public IndegreeTopologicalSort(Digraph digraph) {
        this.digraph = digraph;
        Iterator i = digraph.vertexIterator();
        while (i.hasNext()) {
            Object vertex = i.next();
            this.vertices.add(vertex);
            this.inDegrees.put(vertex, new InDegree(digraph.incomingSize(vertex)));
        }
        this.current = this.vertices.listIterator();
    }

    public boolean hasNext() {
        return !this.vertices.isEmpty();
    }

    public Object next() {
        boolean progress = true;
        while (this.hasNext()) {
            if (!this.current.hasNext()) {
                if (!progress) break;
                progress = false;
                this.current = this.vertices.listIterator();
            }
            Object vertex = this.current.next();
            InDegree indegree = (InDegree)this.inDegrees.get(vertex);
            if (indegree.value != 0) continue;
            this.removeVertex(vertex);
            this.current.remove();
            return vertex;
        }
        return null;
    }

    private void removeVertex(Object vertex) {
        ArcIterator i = this.digraph.outgoingIterator(vertex);
        while (i.hasNext()) {
            i.next();
            Object dst = i.getDestination();
            InDegree indegree = (InDegree)this.inDegrees.get(dst);
            --indegree.value;
        }
    }

    private static class InDegree {
        int value;

        InDegree(int value) {
            this.value = value;
        }
    }
}

