/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.ResultIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitResultIterator
implements ResultIterator {
    protected ResultIterator wrappedIterator;
    protected Map<String, Object> nextDataObjectIds;
    protected int fetchLimit;
    protected int offset;
    protected int fetchedSoFar;
    protected boolean nextRow;

    public LimitResultIterator(ResultIterator wrappedIterator, int offset, int fetchLimit) throws CayenneException {
        if (wrappedIterator == null) {
            throw new CayenneException("Null wrapped iterator.");
        }
        this.wrappedIterator = wrappedIterator;
        this.offset = offset;
        this.fetchLimit = fetchLimit;
        this.checkOffset();
        this.checkNextRow();
    }

    private void checkOffset() throws CayenneException {
        for (int i = 0; i < this.offset && this.wrappedIterator.hasNextRow(); ++i) {
            this.wrappedIterator.nextRow();
        }
    }

    private void checkNextRow() throws CayenneException {
        this.nextRow = false;
        if ((this.fetchLimit <= 0 || this.fetchedSoFar < this.fetchLimit) && this.wrappedIterator.hasNextRow()) {
            this.nextRow = true;
            ++this.fetchedSoFar;
        }
    }

    @Override
    public void close() throws CayenneException {
        this.wrappedIterator.close();
    }

    @Override
    public List<?> allRows() throws CayenneException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.hasNextRow()) {
            list.add(this.nextRow());
        }
        return list;
    }

    @Override
    public boolean hasNextRow() throws CayenneException {
        return this.nextRow;
    }

    @Override
    public Object nextRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        Object row = this.wrappedIterator.nextRow();
        this.checkNextRow();
        return row;
    }

    @Override
    public void skipRow() throws CayenneException {
        this.wrappedIterator.skipRow();
    }
}

