/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.Util;

public class SQLTemplateValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath treeNodePath, Validator validator) {
        SQLTemplate query = (SQLTemplate)treeNodePath.getObject();
        this.validateName(query, treeNodePath, validator);
        this.validateRoot(query, treeNodePath, validator);
        this.validateDefaultSQL(query, treeNodePath, validator);
    }

    protected void validateDefaultSQL(SQLTemplate query, ProjectPath path, Validator validator) {
        if (Util.isEmptyString(query.getDefaultTemplate())) {
            for (String key : query.getTemplateKeys()) {
                if (Util.isEmptyString(query.getCustomTemplate(key))) continue;
                return;
            }
            validator.registerWarning("Query has no default SQL template", path);
        }
    }

    protected void validateRoot(SQLTemplate query, ProjectPath path, Validator validator) {
        DataMap map = path.firstInstanceOf(DataMap.class);
        if (query.getRoot() == null && map != null) {
            validator.registerWarning("Query has no root", path);
        }
    }

    protected void validateName(Query query, ProjectPath path, Validator validator) {
        String name = query.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed Query.", path);
            return;
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
        for (Query otherQuery : map.getQueries()) {
            if (otherQuery == query || !name.equals(otherQuery.getName())) continue;
            validator.registerError("Duplicate Query name: " + name + ".", path);
            break;
        }
    }
}

