/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.AbstractCallback;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CallbackOnEntity
extends AbstractCallback {
    private Method callbackMethod;

    CallbackOnEntity(Class<?> objectClass, String methodName) throws IllegalArgumentException {
        this.callbackMethod = this.findMethod(objectClass, methodName);
    }

    @Override
    public void performCallback(Object entity) {
        try {
            this.callbackMethod.invoke(entity, (Object[])null);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error invoking entity callback method " + this.callbackMethod.getName(), e);
        }
    }

    public String toString() {
        return "callback-entity: " + this.callbackMethod.getDeclaringClass().getName() + "." + this.callbackMethod.getName();
    }

    private Method findMethod(Class<?> objectClass, String methodName) throws IllegalArgumentException {
        Method[] methods;
        for (Method method : methods = objectClass.getDeclaredMethods()) {
            int modifiers;
            if (!methodName.equals(method.getName()) || Modifier.isStatic(modifiers = method.getModifiers()) || !Void.TYPE.isAssignableFrom(method.getReturnType()) || method.getParameterTypes().length != 0) continue;
            if (!Util.isAccessible(method)) {
                method.setAccessible(true);
            }
            return method;
        }
        throw new IllegalArgumentException("Class " + objectClass.getName() + " has no valid callback method '" + methodName + "'");
    }
}

