/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import java.util.List;
import java.util.Map;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.reflect.ClassDescriptor;

class RangeQuery
implements Query {
    private String cacheKey;
    private int fetchOffset;
    private int fetchLimit;
    private Query originatingQuery;

    private RangeQuery() {
    }

    RangeQuery(String cacheKey, int fetchStartIndex, int fetchLimit, Query originatingQuery) {
        this.cacheKey = cacheKey;
        this.fetchOffset = fetchStartIndex;
        this.fetchLimit = fetchLimit;
        this.originatingQuery = originatingQuery;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        final QueryMetadata originatingMetadata = this.originatingQuery.getMetaData(resolver);
        return new QueryMetadata(){

            @Override
            public Query getOrginatingQuery() {
                return RangeQuery.this.originatingQuery;
            }

            @Override
            public List<Object> getResultSetMapping() {
                return null;
            }

            @Override
            public String getCacheKey() {
                return RangeQuery.this.cacheKey;
            }

            @Override
            public String[] getCacheGroups() {
                return null;
            }

            @Override
            public int getFetchOffset() {
                return RangeQuery.this.fetchOffset;
            }

            @Override
            @Deprecated
            public int getFetchStartIndex() {
                return this.getFetchOffset();
            }

            @Override
            public int getFetchLimit() {
                return RangeQuery.this.fetchLimit;
            }

            @Override
            public boolean isFetchingDataRows() {
                return originatingMetadata.isFetchingDataRows();
            }

            @Override
            public int getPageSize() {
                return 0;
            }

            @Override
            @Deprecated
            public String getCachePolicy() {
                return "nocache";
            }

            @Override
            public QueryCacheStrategy getCacheStrategy() {
                return QueryCacheStrategy.getDefaultStrategy();
            }

            @Override
            public PrefetchTreeNode getPrefetchTree() {
                return originatingMetadata.getPrefetchTree();
            }

            @Override
            public DataMap getDataMap() {
                throw new UnsupportedOperationException();
            }

            @Override
            public DbEntity getDbEntity() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ObjEntity getObjEntity() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ClassDescriptor getClassDescriptor() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Procedure getProcedure() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Map<String, String> getPathSplitAliases() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isRefreshingObjects() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isResolvingInherited() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getStatementFetchSize() {
                return 0;
            }
        };
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        throw new UnsupportedOperationException();
    }
}

