/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.access.select.SelectColumn;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntitySelectColumn
implements SelectColumn {
    private int jdbcType;
    private String dataRowKey;
    private ExtendedType converter;
    private String columnName;
    private List<DbRelationship> path;

    EntitySelectColumn() {
    }

    @Override
    public int getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public String getColumnName(DbEntity unionRoot, String tableAlias) {
        if (tableAlias == null || tableAlias.length() == 0) {
            return this.columnName;
        }
        return tableAlias + '.' + this.columnName;
    }

    @Override
    public String getDataRowKey() {
        return this.dataRowKey;
    }

    @Override
    public List<DbRelationship> getPath(DbEntity unionRoot) {
        if (this.path == null) {
            return Collections.emptyList();
        }
        return this.path;
    }

    ExtendedType getConverter() {
        return this.converter;
    }

    void setJdbcType(int jdbcType) {
        this.jdbcType = jdbcType;
    }

    void setPath(List<DbRelationship> path) {
        this.path = path;
    }

    void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    void setDataRowKey(String dataRowKey) {
        this.dataRowKey = dataRowKey;
    }

    void setConverter(ExtendedType converter) {
        this.converter = converter;
    }
}

