/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;
import org.apache.cayenne.query.Query;

public class CreateQueryUndoableEdit
extends CayenneUndoableEdit {
    private DataDomain domain;
    private DataMap map;
    private Query query;

    public CreateQueryUndoableEdit(DataDomain domain, DataMap map, Query query) {
        this.domain = domain;
        this.map = map;
        this.query = query;
    }

    public void redo() throws CannotRedoException {
        CreateQueryAction action = (CreateQueryAction)this.actionManager.getAction(CreateQueryAction.getActionName());
        action.createQuery(this.domain, this.map, this.query);
    }

    public String getPresentationName() {
        return "Create Query";
    }

    public void undo() throws CannotUndoException {
        RemoveAction action = (RemoveAction)this.actionManager.getAction(RemoveAction.getActionName());
        action.removeQuery(this.map, this.query);
    }
}

