/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import junit.framework.TestSuite;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.NumberConverter;
import org.apache.commons.beanutils.converters.NumberConverterTestBase;

public class IntegerConverterTestCase
extends NumberConverterTestBase {
    private Converter converter;

    public static TestSuite suite() {
        return new TestSuite(IntegerConverterTestCase.class);
    }

    public IntegerConverterTestCase(String name) {
        super(name);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Integer.class;
    }

    @Override
    protected NumberConverter makeConverter() {
        return new IntegerConverter();
    }

    @Override
    protected NumberConverter makeConverter(Object defaultValue) {
        return new IntegerConverter(defaultValue);
    }

    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Integer.valueOf("-12");
        this.numbers[1] = Integer.valueOf("13");
        this.numbers[2] = Integer.valueOf("-22");
        this.numbers[3] = Integer.valueOf("23");
    }

    public void tearDown() throws Exception {
        this.converter = null;
    }

    public void testInvalidAmount() {
        NumberConverter converter = this.makeConverter();
        Class<Integer> clazz = Integer.class;
        Long min = Integer.MIN_VALUE;
        Long max = Integer.MAX_VALUE;
        Long minMinusOne = min - 1L;
        Long maxPlusOne = max + 1L;
        IntegerConverterTestCase.assertEquals((String)"Minimum", (Object)Integer.MIN_VALUE, (Object)converter.convert(clazz, (Object)min));
        IntegerConverterTestCase.assertEquals((String)"Maximum", (Object)Integer.MAX_VALUE, (Object)converter.convert(clazz, (Object)max));
        try {
            IntegerConverterTestCase.assertEquals((String)"Minimum - 1", null, (Object)converter.convert(clazz, (Object)minMinusOne));
            IntegerConverterTestCase.fail((String)"Less than minimum, expected ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IntegerConverterTestCase.assertEquals((String)"Maximum + 1", null, (Object)converter.convert(clazz, (Object)maxPlusOne));
            IntegerConverterTestCase.fail((String)"More than maximum, expected ConversionException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testInvalidDefaultObject() {
        NumberConverter converter = this.makeConverter();
        try {
            converter.setDefaultValue((Object)"notANumber");
            IntegerConverterTestCase.fail((String)"Invalid default value not detected!");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Integer.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Integer.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Integer[] expected = new Integer[]{Integer.MIN_VALUE, -17, -1, 0, 1, 17, Integer.MAX_VALUE, 7, 8, 9, 10, 11, 12};
        for (int i = 0; i < expected.length; ++i) {
            IntegerConverterTestCase.assertEquals((String)(message[i] + " to Integer"), (Object)expected[i], (Object)this.converter.convert(Integer.class, input[i]));
            IntegerConverterTestCase.assertEquals((String)(message[i] + " to int"), (Object)expected[i], (Object)this.converter.convert(Integer.TYPE, input[i]));
            IntegerConverterTestCase.assertEquals((String)(message[i] + " to null type"), (Object)expected[i], (Object)this.converter.convert(null, input[i]));
        }
    }
}

