/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.core.output;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.geometry.io.core.AbstractGeometryIOMetadata;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.core.output.GeometryOutput;

public class FileGeometryOutput
extends AbstractGeometryIOMetadata
implements GeometryOutput {
    private final Path file;

    public FileGeometryOutput(Path file) {
        this(file, null);
    }

    public FileGeometryOutput(Path file, Charset charset) {
        super(GeometryIOUtils.getFileName(file), charset);
        this.file = file;
    }

    public Path getFile() {
        return this.file;
    }

    @Override
    public OutputStream getOutputStream() {
        return GeometryIOUtils.getUnchecked(() -> new BufferedOutputStream(Files.newOutputStream(this.file, new OpenOption[0])));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[file= ").append(this.getFile()).append(']');
        return sb.toString();
    }
}

