/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;

public abstract class AbstractPathConnector<E extends ConnectableElement<E>> {
    private final NavigableSet<E> pathElements = new TreeSet();
    private final NavigableSet<E> pathElementsDescending = this.pathElements.descendingSet();
    private final List<E> possibleConnections = new ArrayList();
    private final List<E> possiblePointConnections = new ArrayList();

    protected void connectPathElements(Iterable<E> elements) {
        elements.forEach(this::addPathElement);
        for (ConnectableElement element : elements) {
            this.makeForwardConnection(element);
        }
    }

    protected void addPathElement(E element) {
        this.pathElements.add(element);
    }

    protected List<E> computePathRoots() {
        for (ConnectableElement element : this.pathElements) {
            this.followForwardConnections(element);
        }
        ArrayList rootEntries = new ArrayList();
        for (ConnectableElement element : this.pathElements) {
            Object root = element.exportPath();
            if (root == null) continue;
            rootEntries.add(root);
        }
        this.pathElements.clear();
        this.possibleConnections.clear();
        this.possiblePointConnections.clear();
        return rootEntries;
    }

    private void followForwardConnections(E start) {
        E current = start;
        while (current != null && ((ConnectableElement)current).hasEnd() && !((ConnectableElement)current).hasNext()) {
            current = this.makeForwardConnection(current);
        }
    }

    private E makeForwardConnection(E element) {
        this.findPossibleConnections(element);
        ConnectableElement next = null;
        if (!this.possiblePointConnections.isEmpty()) {
            next = this.possiblePointConnections.size() == 1 ? (ConnectableElement)this.possiblePointConnections.get(0) : this.selectPointConnection(element, this.possiblePointConnections);
        } else if (!this.possibleConnections.isEmpty()) {
            ConnectableElement connectableElement = next = this.possibleConnections.size() == 1 ? (ConnectableElement)this.possibleConnections.get(0) : this.selectConnection(element, this.possibleConnections);
        }
        if (next != null) {
            element.connectTo(next);
        }
        return (E)next;
    }

    private void findPossibleConnections(E element) {
        block2: {
            ConnectableElement candidate;
            this.possibleConnections.clear();
            this.possiblePointConnections.clear();
            if (!element.hasEnd()) break block2;
            Object searchKey = element.getConnectionSearchKey();
            Iterator iterator = this.pathElements.tailSet(searchKey).iterator();
            while (iterator.hasNext() && (this.addPossibleConnection(element, candidate = (ConnectableElement)iterator.next()) || element.shouldContinueConnectionSearch((ConnectableElement)candidate, true))) {
            }
            iterator = this.pathElementsDescending.tailSet(searchKey, false).iterator();
            while (iterator.hasNext() && (this.addPossibleConnection(element, candidate = (ConnectableElement)iterator.next()) || element.shouldContinueConnectionSearch((ConnectableElement)candidate, false))) {
            }
        }
    }

    private boolean addPossibleConnection(E element, E candidate) {
        if (element != candidate && !((ConnectableElement)candidate).hasPrevious() && ((ConnectableElement)candidate).hasStart() && ((ConnectableElement)element).canConnectTo(candidate)) {
            if (((ConnectableElement)element).endPointsEq(candidate)) {
                this.possiblePointConnections.add(candidate);
            } else {
                this.possibleConnections.add(candidate);
            }
            return true;
        }
        return false;
    }

    protected E selectPointConnection(E incoming, List<E> outgoingList) {
        double smallestAngle = 0.0;
        ConnectableElement bestElement = null;
        boolean bestIsUnconnected = false;
        for (ConnectableElement outgoing : outgoingList) {
            boolean isUnconnected;
            double angle = Math.abs(incoming.getRelativeAngle((ConnectableElement)outgoing));
            boolean bl = isUnconnected = !outgoing.hasNext();
            if (bestElement != null && (bestIsUnconnected || !isUnconnected) && (bestIsUnconnected != isUnconnected || !(angle < smallestAngle))) continue;
            smallestAngle = angle;
            bestElement = outgoing;
            bestIsUnconnected = isUnconnected;
        }
        return (E)bestElement;
    }

    protected abstract E selectConnection(E var1, List<E> var2);

    public static abstract class ConnectableElement<E extends ConnectableElement<E>>
    implements Comparable<E> {
        private E next;
        private E previous;
        private boolean exported;

        public boolean hasNext() {
            return this.next != null;
        }

        public E getNext() {
            return this.next;
        }

        protected void setNext(E next) {
            this.next = next;
        }

        public boolean hasPrevious() {
            return this.previous != null;
        }

        public E getPrevious() {
            return this.previous;
        }

        protected void setPrevious(E previous) {
            this.previous = previous;
        }

        public void connectTo(E nextElement) {
            this.setNext(nextElement);
            ((ConnectableElement)nextElement).setPrevious(this.getSelf());
        }

        public E exportPath() {
            if (this.markExported()) {
                E current;
                E root = this.getSelf();
                for (current = this.next; current != null && ((ConnectableElement)current).markExported(); current = ((ConnectableElement)current).getNext()) {
                }
                for (current = this.previous; current != null && ((ConnectableElement)current).markExported(); current = ((ConnectableElement)current).getPrevious()) {
                    root = current;
                }
                return root;
            }
            return null;
        }

        protected boolean markExported() {
            if (!this.exported) {
                this.exported = true;
                return true;
            }
            return false;
        }

        public abstract boolean hasStart();

        public abstract boolean hasEnd();

        public abstract boolean endPointsEq(E var1);

        public abstract boolean canConnectTo(E var1);

        public abstract double getRelativeAngle(E var1);

        public abstract E getConnectionSearchKey();

        public abstract boolean shouldContinueConnectionSearch(E var1, boolean var2);

        protected abstract E getSelf();
    }
}

