/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.issues;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.Variables;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JXPath177Test {
    Map model = new HashMap();

    public JXPath177Test() {
        this.model.put("name", "ROOT name");
        HashMap<String, String> x = new HashMap<String, String>();
        this.model.put("x", x);
        x.put("name", "X name");
    }

    private void doTest(String xp, String expected) {
        JXPathContext xpathContext = JXPathContext.newContext((Object)this.model);
        xpathContext.setVariables((Variables)new JXPathVariablesResolver(this.model));
        Pointer p = xpathContext.getPointer(xp);
        Object result = p.getNode();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testJx177() {
        this.doTest("name", "ROOT name");
        this.doTest("/x/name", "X name");
        this.doTest("$__root/x/name", "X name");
    }

    @Test
    public void testJx177_Union1() {
        this.doTest("$__root/x/name|name", "X name");
    }

    @Test
    public void testJx177_Union2() {
        this.doTest("$__root/x/unexisting|name", "ROOT name");
    }

    private static final class JXPathVariablesResolver
    implements Variables {
        private static final long serialVersionUID = -1106360826446119597L;
        public static final String ROOT_VAR = "__root";
        private final Object root;

        public JXPathVariablesResolver(Object root) {
            this.root = root;
        }

        public void declareVariable(String varName, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object getVariable(String varName) {
            if (varName == null) {
                throw new IllegalArgumentException("varName");
            }
            if (!varName.equals(ROOT_VAR)) {
                throw new IllegalArgumentException("Variable is not declared: " + varName);
            }
            return this.root;
        }

        public boolean isDeclaredVariable(String varName) {
            if (varName == null) {
                throw new IllegalArgumentException("varName");
            }
            return varName.equals(ROOT_VAR);
        }

        public void undeclareVariable(String varName) {
            throw new UnsupportedOperationException();
        }
    }
}

