/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.twod.hull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.euclidean.twod.hull.ConvexHull2D;
import org.apache.commons.math3.geometry.euclidean.twod.hull.ConvexHullGenerator2D;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConvexHullGenerator2DAbstractTest {
    protected ConvexHullGenerator2D generator;
    protected RandomGenerator random;

    protected abstract ConvexHullGenerator2D createConvexHullGenerator(boolean var1);

    protected Collection<Vector2D> reducePoints(Collection<Vector2D> points) {
        return points;
    }

    @Before
    public void setUp() {
        this.generator = this.createConvexHullGenerator(false);
        this.random = new MersenneTwister(10);
    }

    @Test(expected=NullArgumentException.class)
    public void testNullArgument() {
        this.generator.generate(null);
    }

    @Test
    public void testEmpty() {
        ConvexHull2D hull = this.generator.generate(Collections.emptyList());
        Assert.assertTrue((hull.getVertices().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((hull.getLineSegments().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOnePoint() {
        List<Vector2D> points = this.createRandomPoints(1);
        ConvexHull2D hull = this.generator.generate(points);
        Assert.assertTrue((hull.getVertices().length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((hull.getLineSegments().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTwoPoints() {
        List<Vector2D> points = this.createRandomPoints(2);
        ConvexHull2D hull = this.generator.generate(points);
        Assert.assertTrue((hull.getVertices().length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((hull.getLineSegments().length == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAllIdentical() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        points.add(new Vector2D(1.0, 1.0));
        points.add(new Vector2D(1.0, 1.0));
        points.add(new Vector2D(1.0, 1.0));
        points.add(new Vector2D(1.0, 1.0));
        ConvexHull2D hull = this.generator.generate(points);
        Assert.assertTrue((hull.getVertices().length == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testConvexHull() {
        for (int i = 0; i < 100; ++i) {
            int size = (int)FastMath.floor((double)(this.random.nextDouble() * 96.0 + 4.0));
            List<Vector2D> points = this.createRandomPoints(size);
            ConvexHull2D hull = this.generator.generate(this.reducePoints(points));
            this.checkConvexHull(points, hull);
        }
    }

    @Test
    public void testCollinearPoints() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        points.add(new Vector2D(1.0, 1.0));
        points.add(new Vector2D(2.0, 2.0));
        points.add(new Vector2D(2.0, 4.0));
        points.add(new Vector2D(4.0, 1.0));
        points.add(new Vector2D(10.0, 1.0));
        ConvexHull2D hull = this.generator.generate(points);
        this.checkConvexHull(points, hull);
    }

    @Test
    public void testCollinearPointsReverse() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        points.add(new Vector2D(1.0, 1.0));
        points.add(new Vector2D(2.0, 2.0));
        points.add(new Vector2D(2.0, 4.0));
        points.add(new Vector2D(10.0, 1.0));
        points.add(new Vector2D(4.0, 1.0));
        ConvexHull2D hull = this.generator.generate(points);
        this.checkConvexHull(points, hull);
    }

    @Test
    public void testCollinearPointsIncluded() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        points.add(new Vector2D(1.0, 1.0));
        points.add(new Vector2D(2.0, 2.0));
        points.add(new Vector2D(2.0, 4.0));
        points.add(new Vector2D(4.0, 1.0));
        points.add(new Vector2D(10.0, 1.0));
        ConvexHull2D hull = this.createConvexHullGenerator(true).generate(points);
        this.checkConvexHull(points, hull, true);
    }

    @Test
    public void testCollinearPointsIncludedReverse() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        points.add(new Vector2D(1.0, 1.0));
        points.add(new Vector2D(2.0, 2.0));
        points.add(new Vector2D(2.0, 4.0));
        points.add(new Vector2D(10.0, 1.0));
        points.add(new Vector2D(4.0, 1.0));
        ConvexHull2D hull = this.createConvexHullGenerator(true).generate(points);
        this.checkConvexHull(points, hull, true);
    }

    @Test
    public void testIdenticalPoints() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        points.add(new Vector2D(1.0, 1.0));
        points.add(new Vector2D(2.0, 2.0));
        points.add(new Vector2D(2.0, 4.0));
        points.add(new Vector2D(4.0, 1.0));
        points.add(new Vector2D(1.0, 1.0));
        ConvexHull2D hull = this.generator.generate(points);
        this.checkConvexHull(points, hull);
    }

    @Test
    public void testIdenticalPoints2() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        points.add(new Vector2D(1.0, 1.0));
        points.add(new Vector2D(2.0, 2.0));
        points.add(new Vector2D(2.0, 4.0));
        points.add(new Vector2D(4.0, 1.0));
        points.add(new Vector2D(1.0, 1.0));
        ConvexHull2D hull = this.createConvexHullGenerator(true).generate(points);
        this.checkConvexHull(points, hull, true);
    }

    @Test
    public void testClosePoints() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        points.add(new Vector2D(1.0, 1.0));
        points.add(new Vector2D(2.0, 2.0));
        points.add(new Vector2D(2.0, 4.0));
        points.add(new Vector2D(4.0, 1.0));
        points.add(new Vector2D(1.00001, 1.0));
        ConvexHull2D hull = this.generator.generate(points);
        this.checkConvexHull(points, hull);
    }

    @Test
    public void testCollinearPointOnExistingBoundary() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        points.add(new Vector2D(7.3152, 34.7472));
        points.add(new Vector2D(6.400799999999997, 34.747199999999985));
        points.add(new Vector2D(5.486399999999997, 34.7472));
        points.add(new Vector2D(4.876799999999999, 34.7472));
        points.add(new Vector2D(4.876799999999999, 34.1376));
        points.add(new Vector2D(4.876799999999999, 30.48));
        points.add(new Vector2D(6.0959999999999965, 30.48));
        points.add(new Vector2D(6.0959999999999965, 34.1376));
        points.add(new Vector2D(7.315199999999996, 34.1376));
        points.add(new Vector2D(7.3152, 30.48));
        ConvexHull2D hull = this.createConvexHullGenerator(false).generate(points);
        this.checkConvexHull(points, hull);
    }

    @Test
    public void testCollinearPointsInAnyOrder() {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        points.add(new Vector2D(16.078200000000184, -36.52519999989808));
        points.add(new Vector2D(19.164300000000186, -36.52519999989808));
        points.add(new Vector2D(19.1643, -25.28136477910407));
        points.add(new Vector2D(19.1643, -17.678400000004157));
        ConvexHull2D hull = this.createConvexHullGenerator(false).generate(points);
        this.checkConvexHull(points, hull);
        hull = this.createConvexHullGenerator(true).generate(points);
        this.checkConvexHull(points, hull, true);
        points.clear();
        points.add(new Vector2D(0.0, -29.959696875));
        points.add(new Vector2D(0.0, -31.621809375));
        points.add(new Vector2D(0.0, -28.435696875));
        points.add(new Vector2D(0.0, -33.145809375));
        points.add(new Vector2D(3.048, -33.145809375));
        points.add(new Vector2D(3.048, -31.621809375));
        points.add(new Vector2D(3.048, -29.959696875));
        points.add(new Vector2D(4.572, -33.145809375));
        points.add(new Vector2D(4.572, -28.435696875));
        hull = this.createConvexHullGenerator(false).generate(points);
        this.checkConvexHull(points, hull);
        hull = this.createConvexHullGenerator(true).generate(points);
        this.checkConvexHull(points, hull, true);
    }

    @Test
    public void testIssue1123() {
        int i;
        int[][] data;
        ArrayList<Vector2D> points = new ArrayList<Vector2D>();
        for (int[] line : data = new int[][]{{-11, -1}, {-11, 0}, {-11, 1}, {-10, -3}, {-10, -2}, {-10, -1}, {-10, 0}, {-10, 1}, {-10, 2}, {-10, 3}, {-9, -4}, {-9, -3}, {-9, -2}, {-9, -1}, {-9, 0}, {-9, 1}, {-9, 2}, {-9, 3}, {-9, 4}, {-8, -5}, {-8, -4}, {-8, -3}, {-8, -2}, {-8, -1}, {-8, 0}, {-8, 1}, {-8, 2}, {-8, 3}, {-8, 4}, {-8, 5}, {-7, -6}, {-7, -5}, {-7, -4}, {-7, -3}, {-7, -2}, {-7, -1}, {-7, 0}, {-7, 1}, {-7, 2}, {-7, 3}, {-7, 4}, {-7, 5}, {-7, 6}, {-6, -7}, {-6, -6}, {-6, -5}, {-6, -4}, {-6, -3}, {-6, -2}, {-6, -1}, {-6, 0}, {-6, 1}, {-6, 2}, {-6, 3}, {-6, 4}, {-6, 5}, {-6, 6}, {-6, 7}, {-5, -7}, {-5, -6}, {-5, -5}, {-5, -4}, {-5, -3}, {-5, -2}, {-5, 4}, {-5, 5}, {-5, 6}, {-5, 7}, {-4, -7}, {-4, -6}, {-4, -5}, {-4, -4}, {-4, -3}, {-4, -2}, {-4, 4}, {-4, 5}, {-4, 6}, {-4, 7}, {-3, -8}, {-3, -7}, {-3, -6}, {-3, -5}, {-3, -4}, {-3, -3}, {-3, -2}, {-3, 4}, {-3, 5}, {-3, 6}, {-3, 7}, {-3, 8}, {-2, -8}, {-2, -7}, {-2, -6}, {-2, -5}, {-2, -4}, {-2, -3}, {-2, -2}, {-2, 4}, {-2, 5}, {-2, 6}, {-2, 7}, {-2, 8}, {-1, -8}, {-1, -7}, {-1, -6}, {-1, -5}, {-1, -4}, {-1, -3}, {-1, -2}, {-1, 4}, {-1, 5}, {-1, 6}, {-1, 7}, {-1, 8}, {0, -8}, {0, -7}, {0, -6}, {0, -5}, {0, -4}, {0, -3}, {0, -2}, {0, 4}, {0, 5}, {0, 6}, {0, 7}, {0, 8}, {1, -8}, {1, -7}, {1, -6}, {1, -5}, {1, -4}, {1, -3}, {1, -2}, {1, -1}, {1, 0}, {1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {2, -8}, {2, -7}, {2, -6}, {2, -5}, {2, -4}, {2, -3}, {2, -2}, {2, -1}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, {3, -8}, {3, -7}, {3, -6}, {3, -5}, {3, -4}, {3, -3}, {3, -2}, {3, -1}, {3, 0}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {4, -7}, {4, -6}, {4, -5}, {4, -4}, {4, -3}, {4, -2}, {4, -1}, {4, 0}, {4, 1}, {4, 2}, {4, 3}, {4, 4}, {4, 5}, {4, 6}, {4, 7}, {5, -7}, {5, -6}, {5, -5}, {5, -4}, {5, -3}, {5, -2}, {5, -1}, {5, 0}, {5, 1}, {5, 2}, {5, 3}, {5, 4}, {5, 5}, {5, 6}, {5, 7}, {6, -7}, {6, -6}, {6, -5}, {6, -4}, {6, -3}, {6, -2}, {6, -1}, {6, 0}, {6, 1}, {6, 2}, {6, 3}, {6, 4}, {6, 5}, {6, 6}, {6, 7}, {7, -6}, {7, -5}, {7, -4}, {7, -3}, {7, -2}, {7, -1}, {7, 0}, {7, 1}, {7, 2}, {7, 3}, {7, 4}, {7, 5}, {7, 6}, {8, -5}, {8, -4}, {8, -3}, {8, -2}, {8, -1}, {8, 0}, {8, 1}, {8, 2}, {8, 3}, {8, 4}, {8, 5}, {9, -4}, {9, -3}, {9, -2}, {9, -1}, {9, 0}, {9, 1}, {9, 2}, {9, 3}, {9, 4}, {10, -3}, {10, -2}, {10, -1}, {10, 0}, {10, 1}, {10, 2}, {10, 3}, {11, -1}, {11, 0}, {11, 1}}) {
            points.add(new Vector2D((double)line[0], (double)line[1]));
        }
        Vector2D[] referenceHull = new Vector2D[]{new Vector2D(-11.0, -1.0), new Vector2D(-10.0, -3.0), new Vector2D(-6.0, -7.0), new Vector2D(-3.0, -8.0), new Vector2D(3.0, -8.0), new Vector2D(6.0, -7.0), new Vector2D(10.0, -3.0), new Vector2D(11.0, -1.0), new Vector2D(11.0, 1.0), new Vector2D(10.0, 3.0), new Vector2D(6.0, 7.0), new Vector2D(3.0, 8.0), new Vector2D(-3.0, 8.0), new Vector2D(-6.0, 7.0), new Vector2D(-10.0, 3.0), new Vector2D(-11.0, 1.0)};
        ConvexHull2D convHull = this.generator.generate(points);
        Region hullRegion = convHull.createRegion();
        Assert.assertEquals((double)274.0, (double)hullRegion.getSize(), (double)1.0E-12);
        double perimeter = 0.0;
        for (i = 0; i < referenceHull.length; ++i) {
            perimeter += Vector2D.distance((Vector2D)referenceHull[i], (Vector2D)referenceHull[(i + 1) % referenceHull.length]);
        }
        Assert.assertEquals((double)perimeter, (double)hullRegion.getBoundarySize(), (double)1.0E-12);
        for (i = 0; i < referenceHull.length; ++i) {
            Assert.assertEquals((Object)Region.Location.BOUNDARY, (Object)hullRegion.checkPoint((Point)referenceHull[i]));
        }
    }

    protected final List<Vector2D> createRandomPoints(int size) {
        ArrayList<Vector2D> points = new ArrayList<Vector2D>(size);
        for (int i = 0; i < size; ++i) {
            points.add(new Vector2D(this.random.nextDouble() * 2.0 - 1.0, this.random.nextDouble() * 2.0 - 1.0));
        }
        return points;
    }

    protected final void checkConvexHull(Collection<Vector2D> points, ConvexHull2D hull) {
        this.checkConvexHull(points, hull, false);
    }

    protected final void checkConvexHull(Collection<Vector2D> points, ConvexHull2D hull, boolean includesCollinearPoints) {
        this.checkConvexHull(points, hull, includesCollinearPoints, 1.0E-10);
    }

    protected final void checkConvexHull(Collection<Vector2D> points, ConvexHull2D hull, boolean includesCollinearPoints, double tolerance) {
        Assert.assertNotNull((Object)hull);
        Assert.assertTrue((boolean)this.isConvex(hull, includesCollinearPoints, tolerance));
        this.checkPointsInsideHullRegion(points, hull, includesCollinearPoints);
    }

    protected final boolean isConvex(ConvexHull2D hull, boolean includesCollinearPoints, double tolerance) {
        Vector2D[] points = hull.getVertices();
        int sign = 0;
        for (int i = 0; i < points.length; ++i) {
            Vector2D p1 = points[i == 0 ? points.length - 1 : i - 1];
            Vector2D p2 = points[i];
            Vector2D p3 = points[i == points.length - 1 ? 0 : i + 1];
            Vector2D d1 = p2.subtract((Vector)p1);
            Vector2D d2 = p3.subtract((Vector)p2);
            Assert.assertTrue((d1.getNorm() > 1.0E-10 ? 1 : 0) != 0);
            Assert.assertTrue((d2.getNorm() > 1.0E-10 ? 1 : 0) != 0);
            double cross = MathArrays.linearCombination((double)d1.getX(), (double)d2.getY(), (double)(-d1.getY()), (double)d2.getX());
            int cmp = Precision.compareTo((double)cross, (double)0.0, (double)tolerance);
            if (!(sign == 0 || cmp == sign || includesCollinearPoints && cmp == 0)) {
                return false;
            }
            sign = cmp;
        }
        return true;
    }

    protected final void checkPointsInsideHullRegion(Collection<Vector2D> points, ConvexHull2D hull, boolean includesCollinearPoints) {
        List<Vector2D> hullVertices = Arrays.asList(hull.getVertices());
        Region region = hull.createRegion();
        for (Vector2D p : points) {
            Region.Location location = region.checkPoint((Point)p);
            Assert.assertTrue((location != Region.Location.OUTSIDE ? 1 : 0) != 0);
            if (location != Region.Location.BOUNDARY || !includesCollinearPoints) continue;
            Assert.assertTrue((boolean)hullVertices.contains(p));
        }
    }
}

