/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.SynchronizedRandomGenerator;
import org.junit.Assert;
import org.junit.Test;

public class SynchronizedRandomGeneratorTest {
    private final int numberOfThreads = 5;
    private final int numberOfGenerators = 5;
    private final int numberOfSamples = 100000;

    @Test
    public void testAdapter() {
        int seed = 12345;
        MersenneTwister orig = new MersenneTwister(12345);
        SynchronizedRandomGenerator wrap = new SynchronizedRandomGenerator((RandomGenerator)new MersenneTwister(12345));
        int bSize = 67;
        byte[] bOrig = new byte[67];
        byte[] bWrap = new byte[67];
        for (int i = 0; i < 100; ++i) {
            orig.nextBytes(bOrig);
            wrap.nextBytes(bWrap);
            for (int k = 0; k < 67; ++k) {
                Assert.assertEquals((long)bOrig[k], (long)bWrap[k]);
            }
            Assert.assertEquals((long)orig.nextInt(), (long)wrap.nextInt());
            int range = (i + 1) * 89;
            Assert.assertEquals((long)orig.nextInt(range), (long)wrap.nextInt(range));
            Assert.assertEquals((long)orig.nextLong(), (long)wrap.nextLong());
            Assert.assertEquals((Object)orig.nextBoolean(), (Object)wrap.nextBoolean());
            Assert.assertEquals((float)orig.nextFloat(), (float)wrap.nextFloat(), (float)0.0f);
            Assert.assertEquals((double)orig.nextDouble(), (double)wrap.nextDouble(), (double)0.0);
            Assert.assertEquals((double)orig.nextGaussian(), (double)wrap.nextGaussian(), (double)0.0);
        }
    }

    @Test
    public void testMath899Sync() throws Throwable {
        try {
            for (int i = 0; i < 10; ++i) {
                this.doTestMath899(true, 5, 5, 100000);
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private double[] doTestMath899(boolean sync, int numThreads, int numGenerators, final int numSamples) throws InterruptedException, ExecutionException {
        MersenneTwister rng = new MersenneTwister();
        MersenneTwister wrapper = sync ? new SynchronizedRandomGenerator((RandomGenerator)rng) : rng;
        ArrayList<1> tasks = new ArrayList<1>();
        for (int i = 0; i < numGenerators; ++i) {
            tasks.add(new Callable<Double>((RandomGenerator)wrapper){
                final /* synthetic */ RandomGenerator val$wrapper;
                {
                    this.val$wrapper = randomGenerator;
                }

                @Override
                public Double call() {
                    Double lastValue = 0.0;
                    for (int j = 0; j < numSamples; ++j) {
                        lastValue = this.val$wrapper.nextGaussian();
                    }
                    return lastValue;
                }
            });
        }
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        List results = exec.invokeAll(tasks);
        double[] values = new double[numGenerators];
        for (int i = 0; i < numGenerators; ++i) {
            values[i] = (Double)results.get(i).get();
        }
        return values;
    }
}

