/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.runtime;

import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.apache.cxf.binding.corba.types.CorbaTypeEventProducer;

public class CorbaStreamReader
implements XMLStreamReader {
    private CorbaTypeEventProducer eventProducer;
    private int currentState;

    public CorbaStreamReader(CorbaTypeEventProducer evProducer) {
        this.eventProducer = evProducer;
        this.currentState = 7;
    }

    @Override
    public QName getName() {
        return this.eventProducer.getName();
    }

    @Override
    public char[] getTextCharacters() {
        return this.eventProducer.getText().toCharArray();
    }

    @Override
    public int getEventType() {
        return this.currentState;
    }

    @Override
    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    @Override
    public String getNamespaceURI() {
        return this.getName().getNamespaceURI();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        if (this.currentState == 7) {
            return true;
        }
        boolean hasNextEvent = this.eventProducer.hasNext();
        if (!hasNextEvent && this.currentState != 8) {
            this.currentState = 8;
            hasNextEvent = true;
        }
        return hasNextEvent;
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.currentState == 7) {
            this.currentState = 0;
            return 7;
        }
        this.hasNext();
        if (this.currentState != 8) {
            this.currentState = this.eventProducer.next();
        }
        return this.currentState;
    }

    @Override
    public int getTextLength() {
        return this.eventProducer.getText().length();
    }

    @Override
    public boolean isStartElement() {
        return this.currentState == 1;
    }

    @Override
    public boolean isCharacters() {
        return this.currentState == 4;
    }

    @Override
    public boolean isEndElement() {
        return this.currentState == 2;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public int getAttributeCount() {
        List<Attribute> currentAttributes = this.eventProducer.getAttributes();
        if (currentAttributes != null) {
            return currentAttributes.size();
        }
        return 0;
    }

    @Override
    public String getAttributeLocalName(int arg0) {
        Attribute a;
        String ret = null;
        List<Attribute> currentAttributes = this.eventProducer.getAttributes();
        if (currentAttributes != null && (a = currentAttributes.get(arg0)) != null) {
            ret = a.getName().getLocalPart();
        }
        return ret;
    }

    @Override
    public QName getAttributeName(int arg0) {
        Attribute a;
        QName ret = null;
        List<Attribute> currentAttributes = this.eventProducer.getAttributes();
        if (currentAttributes != null && (a = currentAttributes.get(arg0)) != null) {
            ret = a.getName();
        }
        return ret;
    }

    @Override
    public String getAttributeNamespace(int arg0) {
        Attribute a;
        String ret = null;
        List<Attribute> currentAttributes = this.eventProducer.getAttributes();
        if (currentAttributes != null && (a = currentAttributes.get(arg0)) != null) {
            ret = a.getName().getNamespaceURI();
        }
        return ret;
    }

    @Override
    public String getAttributePrefix(int arg0) {
        return null;
    }

    @Override
    public String getAttributeType(int arg0) {
        return "CDATA";
    }

    @Override
    public String getAttributeValue(int arg0) {
        Attribute a;
        String ret = null;
        List<Attribute> currentAttributes = this.eventProducer.getAttributes();
        if (currentAttributes != null && (a = currentAttributes.get(arg0)) != null) {
            ret = a.getValue();
        }
        return ret;
    }

    @Override
    public String getAttributeValue(String arg0, String arg1) {
        return null;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return null;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public Location getLocation() {
        return new Location(){

            @Override
            public int getCharacterOffset() {
                return -1;
            }

            @Override
            public int getColumnNumber() {
                return -1;
            }

            @Override
            public int getLineNumber() {
                return -1;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return null;
            }
        };
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    @Override
    public int getNamespaceCount() {
        List<Namespace> namespaces = this.eventProducer.getNamespaces();
        if (namespaces != null) {
            return namespaces.size();
        }
        return 0;
    }

    @Override
    public String getNamespacePrefix(int arg0) {
        List<Namespace> namespaces = this.eventProducer.getNamespaces();
        if (namespaces == null) {
            return null;
        }
        Namespace ns = namespaces.get(arg0);
        if (ns != null) {
            return ns.getPrefix();
        }
        return null;
    }

    @Override
    public String getNamespaceURI(String arg0) {
        return null;
    }

    @Override
    public String getNamespaceURI(int arg0) {
        List<Namespace> namespaces = this.eventProducer.getNamespaces();
        if (namespaces == null) {
            return null;
        }
        Namespace ns = namespaces.get(arg0);
        if (ns != null) {
            return ns.getNamespaceURI();
        }
        return null;
    }

    @Override
    public String getPIData() {
        return null;
    }

    @Override
    public String getPITarget() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        return null;
    }

    @Override
    public String getText() {
        return this.eventProducer.getText();
    }

    @Override
    public int getTextCharacters(int arg0, char[] arg1, int arg2, int arg3) throws XMLStreamException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean hasName() {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public boolean hasText() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean isAttributeSpecified(int arg0) {
        return false;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }
}

