/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.function;

import java.util.ArrayDeque;
import java.util.Deque;

public class ThreadLocalStack<E> {
    private static final Object NULL_VALUE = new Object();
    private final ThreadLocal<Deque<Object>> deque = ThreadLocal.withInitial(ArrayDeque::new);

    public void push(E item) {
        Deque<Object> st = this.deque.get();
        if (item == null) {
            st.push(NULL_VALUE);
        } else {
            st.push(item);
        }
    }

    public E peek() {
        Deque<Object> st = this.deque.get();
        Object o = st.peek();
        if (o == NULL_VALUE) {
            return null;
        }
        return (E)o;
    }

    public E pop() {
        Deque<Object> st = this.deque.get();
        Object o = st.pop();
        if (o == NULL_VALUE) {
            return null;
        }
        return (E)o;
    }

    public boolean isEmpty() {
        return this.deque.get().isEmpty();
    }
}

