/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.request;

import java.security.Principal;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.w3c.dom.Element;

public class ReceivedToken {
    private static final Logger LOG = LogUtils.getL7dLogger(ReceivedToken.class);
    private Object token;
    private boolean isBinarySecurityToken;
    private boolean isUsernameToken;
    private boolean isDOMElement;
    private String tokenContext;
    private STATE state = STATE.NONE;
    private Principal principal;
    private Set<Principal> roles;

    public ReceivedToken(Object receivedToken) throws STSException {
        if (receivedToken instanceof JAXBElement) {
            QName parentName = ((JAXBElement)receivedToken).getName();
            if (QNameConstants.USERNAME_TOKEN.equals(parentName)) {
                this.isUsernameToken = true;
                LOG.fine("Found a UsernameToken");
            } else if (QNameConstants.BINARY_SECURITY_TOKEN.equals(parentName)) {
                LOG.fine("Found a BinarySecurityToken");
                this.isBinarySecurityToken = true;
            } else if (QNameConstants.SECURITY_TOKEN_REFERENCE.equals(parentName)) {
                LOG.fine("Found SecurityTokenReference");
            } else {
                LOG.fine("Found unknown token object: " + parentName);
                throw new STSException("An unknown element was received", STSException.BAD_REQUEST);
            }
            this.token = ((JAXBElement)receivedToken).getValue();
        } else if (receivedToken instanceof Element) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Found ValidateTarget element: " + ((Element)receivedToken).getLocalName());
            }
            this.token = receivedToken;
            this.isDOMElement = true;
        } else {
            LOG.fine("Found ValidateTarget object of unknown type");
            throw new STSException("An unknown element was received", STSException.BAD_REQUEST);
        }
    }

    public Object getToken() {
        return this.token;
    }

    public void setToken(Object token) {
        this.token = token;
    }

    public boolean isBinarySecurityToken() {
        return this.isBinarySecurityToken;
    }

    public void setBinarySecurityToken(boolean binarySecurityToken) {
        this.isBinarySecurityToken = binarySecurityToken;
    }

    public boolean isUsernameToken() {
        return this.isUsernameToken;
    }

    public void setUsernameToken(boolean usernameToken) {
        this.isUsernameToken = usernameToken;
    }

    public boolean isDOMElement() {
        return this.isDOMElement;
    }

    public void setDOMElement(boolean domElement) {
        this.isDOMElement = domElement;
    }

    public String getTokenContext() {
        return this.tokenContext;
    }

    public void setTokenContext(String tokenContext) {
        this.tokenContext = tokenContext;
    }

    public STATE getState() {
        return this.state;
    }

    public void setState(STATE state) {
        this.state = state;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public Set<Principal> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Principal> roles) {
        this.roles = roles;
    }

    public static enum STATE {
        VALID,
        INVALID,
        CANCELLED,
        EXPIRED,
        NONE;

    }
}

