/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.derivation.impl;

import com.google.common.primitives.Bytes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.params.KDFParameters;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.xmlsec.agreement.CloneableKeyAgreementParameter;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameter;
import org.opensaml.xmlsec.agreement.XMLExpressableKeyAgreementParameter;
import org.opensaml.xmlsec.agreement.impl.KeyAgreementParameterParser;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.algorithm.DigestAlgorithm;
import org.opensaml.xmlsec.derivation.KeyDerivation;
import org.opensaml.xmlsec.derivation.KeyDerivationException;
import org.opensaml.xmlsec.derivation.KeyDerivationSupport;
import org.opensaml.xmlsec.encryption.ConcatKDFParams;
import org.opensaml.xmlsec.encryption.KeyDerivationMethod;
import org.opensaml.xmlsec.signature.DigestMethod;

public class ConcatKDF
extends AbstractInitializableComponent
implements KeyDerivation,
XMLExpressableKeyAgreementParameter,
CloneableKeyAgreementParameter {
    public static final String DEFAULT_DIGEST_METHOD = "http://www.w3.org/2001/04/xmlenc#sha256";
    @NonnullAfterInit
    private String digestMethod;
    @Nullable
    private String algorithmID;
    @Nullable
    private String partyUInfo;
    @Nullable
    private String partyVInfo;
    @Nullable
    private String suppPubInfo;
    @Nullable
    private String suppPrivInfo;

    public String getAlgorithm() {
        return "http://www.w3.org/2009/xmlenc11#ConcatKDF";
    }

    @NonnullAfterInit
    public String getDigestMethod() {
        return this.digestMethod;
    }

    public void setDigestMethod(@Nullable String newDigestMethod) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.digestMethod = StringSupport.trimOrNull((String)newDigestMethod);
    }

    @Nullable
    public String getAlgorithmID() {
        return this.algorithmID;
    }

    public void setAlgorithmID(@Nullable String newAlgorithmID) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.algorithmID = StringSupport.trimOrNull((String)newAlgorithmID);
    }

    @Nullable
    public String getPartyUInfo() {
        return this.partyUInfo;
    }

    public void setPartyUInfo(@Nullable String newPartyUInfo) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.partyUInfo = StringSupport.trimOrNull((String)newPartyUInfo);
    }

    @Nullable
    public String getPartyVInfo() {
        return this.partyVInfo;
    }

    public void setPartyVInfo(@Nullable String newPartyVInfo) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.partyVInfo = StringSupport.trimOrNull((String)newPartyVInfo);
    }

    @Nullable
    public String getSuppPubInfo() {
        return this.suppPubInfo;
    }

    public void setSuppPubInfo(@Nullable String newSuppPubInfo) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.suppPubInfo = StringSupport.trimOrNull((String)newSuppPubInfo);
    }

    @Nullable
    public String getSuppPrivInfo() {
        return this.suppPrivInfo;
    }

    public void setSuppPrivInfo(@Nullable String newSuppPrivInfo) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.suppPrivInfo = StringSupport.trimOrNull((String)newSuppPrivInfo);
    }

    protected void doInitialize() throws ComponentInitializationException {
        try {
            this.decodeParam(this.algorithmID, "AlgorithmID");
            this.decodeParam(this.partyUInfo, "PartyUInfo");
            this.decodeParam(this.partyVInfo, "PartyVInfo");
            this.decodeParam(this.suppPubInfo, "SuppPubInfo");
            this.decodeParam(this.suppPrivInfo, "SuppPrivInfo");
        }
        catch (KeyDerivationException e) {
            throw new ComponentInitializationException("Invalid ConcatKDF param value", (Exception)((Object)e));
        }
        if (this.digestMethod == null) {
            this.digestMethod = DEFAULT_DIGEST_METHOD;
        } else {
            AlgorithmDescriptor descriptor = AlgorithmSupport.getGlobalAlgorithmRegistry().get(this.digestMethod);
            if (descriptor == null) {
                throw new ComponentInitializationException("Specified digest algorithm is unknown: " + this.digestMethod);
            }
            if (!DigestAlgorithm.class.isInstance(descriptor)) {
                throw new ComponentInitializationException("Specified digest algorithm is not a digest algorithm: " + this.digestMethod);
            }
            try {
                this.getDigestInstance(this.digestMethod);
            }
            catch (KeyDerivationException e) {
                throw new ComponentInitializationException("Unable to obtain digest instance", (Exception)((Object)e));
            }
        }
    }

    public SecretKey derive(@Nonnull byte[] secret, @Nonnull String keyAlgorithm, @Nullable Integer keyLength) throws KeyDerivationException {
        Constraint.isNotNull((Object)secret, (String)"Secret byte[] was null");
        Constraint.isNotNull((Object)keyAlgorithm, (String)"Key algorithm was null");
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        String jcaKeyAlgorithm = KeyDerivationSupport.getJCAKeyAlgorithm((String)keyAlgorithm);
        Integer jcaKeyLength = KeyDerivationSupport.getEffectiveKeyLength((String)keyAlgorithm, (Integer)keyLength);
        byte[] otherInfo = Bytes.concat((byte[][])new byte[][]{this.decodeParam(this.algorithmID, "AlgorithmID"), this.decodeParam(this.partyUInfo, "PartyUInfo"), this.decodeParam(this.partyVInfo, "PartyVInfo"), this.decodeParam(this.suppPubInfo, "SuppPubInfo"), this.decodeParam(this.suppPrivInfo, "SuppPrivInfo")});
        byte[] keyBytes = this.derive(secret, otherInfo, jcaKeyLength);
        return new SecretKeySpec(keyBytes, jcaKeyAlgorithm);
    }

    protected byte[] derive(@Nonnull byte[] secret, @Nonnull byte[] otherInfo, @Nonnull Integer keyLength) throws KeyDerivationException {
        Digest digest = this.getDigestInstance(this.digestMethod);
        ConcatenationKDFGenerator concatKDF = new ConcatenationKDFGenerator(digest);
        KDFParameters kdfParams = new KDFParameters(secret, otherInfo);
        concatKDF.init((DerivationParameters)kdfParams);
        int lengthInBytes = keyLength / 8;
        byte[] keyBytes = new byte[lengthInBytes];
        concatKDF.generateBytes(keyBytes, 0, lengthInBytes);
        return keyBytes;
    }

    @Nonnull
    protected Digest getDigestInstance(@Nonnull String digestURI) throws KeyDerivationException {
        switch (digestURI) {
            case "http://www.w3.org/2000/09/xmldsig#sha1": {
                return new SHA1Digest();
            }
            case "http://www.w3.org/2001/04/xmldsig-more#sha224": {
                return new SHA224Digest();
            }
            case "http://www.w3.org/2001/04/xmlenc#sha256": {
                return new SHA256Digest();
            }
            case "http://www.w3.org/2001/04/xmldsig-more#sha384": {
                return new SHA384Digest();
            }
            case "http://www.w3.org/2001/04/xmlenc#sha512": {
                return new SHA512Digest();
            }
            case "http://www.w3.org/2001/04/xmlenc#ripemd160": {
                return new RIPEMD160Digest();
            }
        }
        throw new KeyDerivationException("Specified digest algorithm is unsupported: " + digestURI);
    }

    public ConcatKDF clone() {
        try {
            return (ConcatKDF)((Object)super.clone());
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Nonnull
    protected byte[] decodeParam(@Nullable String value, @Nonnull String name) throws KeyDerivationException {
        String trimmed = StringSupport.trimOrNull((String)value);
        if (trimmed == null) {
            return new byte[0];
        }
        byte[] decoded = null;
        try {
            decoded = Hex.decodeHex((String)trimmed);
        }
        catch (DecoderException e) {
            throw new KeyDerivationException("ConcatKDF parameter was not valid hex-encoded value: " + name, (Throwable)e);
        }
        return decoded;
    }

    @Nullable
    protected static String padParam(@Nullable String value) {
        String trimmed = StringSupport.trimOrNull((String)value);
        if (trimmed == null) {
            return null;
        }
        return "00" + trimmed;
    }

    @Nullable
    protected static String unpadParam(@Nullable String value, @Nullable String name) throws KeyDerivationException {
        String trimmed = StringSupport.trimOrNull((String)value);
        if (trimmed == null) {
            return null;
        }
        if (trimmed.length() < 2) {
            throw new KeyDerivationException("ConcatKDF parameter was not a valid padded hexBinary value (too short): " + name);
        }
        if (trimmed.length() % 2 != 0) {
            throw new KeyDerivationException("ConcatKDF parameter was not a valid padded hexBinary value (odd number of hex digits): " + name);
        }
        if (!trimmed.startsWith("00")) {
            throw new KeyDerivationException("ConcatKDF parameter was not a valid padded hexBinary value (non-byte-aligned): " + name);
        }
        return trimmed.substring(2);
    }

    public XMLObject buildXMLObject() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        KeyDerivationMethod method = (KeyDerivationMethod)XMLObjectSupport.buildXMLObject((QName)KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        method.setAlgorithm(this.getAlgorithm());
        ConcatKDFParams params = (ConcatKDFParams)XMLObjectSupport.buildXMLObject((QName)ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        DigestMethod xmlDigestMethod = (DigestMethod)XMLObjectSupport.buildXMLObject((QName)DigestMethod.DEFAULT_ELEMENT_NAME);
        xmlDigestMethod.setAlgorithm(this.digestMethod);
        params.setDigestMethod(xmlDigestMethod);
        params.setAlgorithmID(ConcatKDF.padParam(this.algorithmID));
        params.setPartyUInfo(ConcatKDF.padParam(this.partyUInfo));
        params.setPartyVInfo(ConcatKDF.padParam(this.partyVInfo));
        params.setSuppPubInfo(ConcatKDF.padParam(this.suppPubInfo));
        params.setSuppPrivInfo(ConcatKDF.padParam(this.suppPrivInfo));
        method.getUnknownXMLObjects().add(params);
        return method;
    }

    @Nonnull
    public static ConcatKDF fromXMLObject(@Nonnull KeyDerivationMethod xmlObject) throws ComponentInitializationException {
        Constraint.isNotNull((Object)xmlObject, (String)"XMLObject was null");
        if (!"http://www.w3.org/2009/xmlenc11#ConcatKDF".equals(xmlObject.getAlgorithm())) {
            throw new ComponentInitializationException("KeyDerivationMethod contains unsupported algorithm: " + xmlObject.getAlgorithm());
        }
        if (xmlObject.getUnknownXMLObjects().size() != 1 || xmlObject.getUnknownXMLObjects(ConcatKDFParams.DEFAULT_ELEMENT_NAME).size() != 1) {
            throw new ComponentInitializationException("KeyDerivationMethod contains unsupported children");
        }
        ConcatKDFParams xmlParams = (ConcatKDFParams)xmlObject.getUnknownXMLObjects(ConcatKDFParams.DEFAULT_ELEMENT_NAME).get(0);
        ConcatKDF parameter = new ConcatKDF();
        if (xmlParams.getDigestMethod() == null || xmlParams.getDigestMethod().getAlgorithm() == null) {
            throw new ComponentInitializationException("KeyDerivationMethod did not contain DigestMethod value");
        }
        parameter.setDigestMethod(xmlParams.getDigestMethod().getAlgorithm());
        try {
            parameter.setAlgorithmID(ConcatKDF.unpadParam(xmlParams.getAlgorithmID(), "AlgorithmID"));
            parameter.setPartyUInfo(ConcatKDF.unpadParam(xmlParams.getPartyUInfo(), "PartyUInfo"));
            parameter.setPartyVInfo(ConcatKDF.unpadParam(xmlParams.getPartyVInfo(), "PartyVInfo"));
            parameter.setSuppPubInfo(ConcatKDF.unpadParam(xmlParams.getSuppPubInfo(), "SuppPubInfo"));
            parameter.setSuppPrivInfo(ConcatKDF.unpadParam(xmlParams.getSuppPrivInfo(), "SuppPrivInfo"));
        }
        catch (KeyDerivationException e) {
            throw new ComponentInitializationException("Invalid ConcatKDF param value", (Exception)((Object)e));
        }
        parameter.initialize();
        return parameter;
    }

    public static class Parser
    implements KeyAgreementParameterParser {
        @Override
        public boolean handles(@Nonnull XMLObject xmlObject) {
            return KeyDerivationMethod.class.isInstance(xmlObject) && "http://www.w3.org/2009/xmlenc11#ConcatKDF".equals(((KeyDerivationMethod)KeyDerivationMethod.class.cast(xmlObject)).getAlgorithm());
        }

        @Override
        public KeyAgreementParameter parse(@Nonnull XMLObject xmlObject) throws KeyAgreementException {
            if (!this.handles(xmlObject)) {
                throw new KeyAgreementException("This implementation does not handle: " + xmlObject.getClass().getName());
            }
            try {
                return ConcatKDF.fromXMLObject((KeyDerivationMethod)KeyDerivationMethod.class.cast(xmlObject));
            }
            catch (ComponentInitializationException e) {
                throw new KeyAgreementException((Throwable)e);
            }
        }
    }
}

