/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.AssertionIDRequestService;
import org.opensaml.saml.saml2.metadata.AttributeProfile;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.NameIDMappingService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml.saml2.metadata.impl.SSODescriptorImpl;

public class IDPSSODescriptorImpl
extends SSODescriptorImpl
implements IDPSSODescriptor {
    @Nullable
    private XSBooleanValue wantAuthnRequestsSigned;
    @Nonnull
    private final XMLObjectChildrenList<SingleSignOnService> singleSignOnServices = new XMLObjectChildrenList((XMLObject)this);
    @Nonnull
    private final XMLObjectChildrenList<NameIDMappingService> nameIDMappingServices = new XMLObjectChildrenList((XMLObject)this);
    @Nonnull
    private final XMLObjectChildrenList<AssertionIDRequestService> assertionIDRequestServices = new XMLObjectChildrenList((XMLObject)this);
    @Nonnull
    private final XMLObjectChildrenList<AttributeProfile> attributeProfiles = new XMLObjectChildrenList((XMLObject)this);
    @Nonnull
    private final XMLObjectChildrenList<Attribute> attributes = new XMLObjectChildrenList((XMLObject)this);

    protected IDPSSODescriptorImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Nullable
    public Boolean getWantAuthnRequestsSigned() {
        if (this.wantAuthnRequestsSigned != null) {
            return this.wantAuthnRequestsSigned.getValue();
        }
        return Boolean.FALSE;
    }

    @Nullable
    public XSBooleanValue getWantAuthnRequestsSignedXSBoolean() {
        return this.wantAuthnRequestsSigned;
    }

    public void setWantAuthnRequestsSigned(@Nullable Boolean newWantSigned) {
        this.wantAuthnRequestsSigned = newWantSigned != null ? (XSBooleanValue)this.prepareForAssignment(this.wantAuthnRequestsSigned, new XSBooleanValue(newWantSigned, false)) : (XSBooleanValue)this.prepareForAssignment(this.wantAuthnRequestsSigned, null);
    }

    public void setWantAuthnRequestsSigned(@Nullable XSBooleanValue wantSigned) {
        this.wantAuthnRequestsSigned = (XSBooleanValue)this.prepareForAssignment(this.wantAuthnRequestsSigned, wantSigned);
    }

    @Nonnull
    @Live
    public List<SingleSignOnService> getSingleSignOnServices() {
        return this.singleSignOnServices;
    }

    @Nonnull
    @Live
    public List<NameIDMappingService> getNameIDMappingServices() {
        return this.nameIDMappingServices;
    }

    @Nonnull
    @Live
    public List<AssertionIDRequestService> getAssertionIDRequestServices() {
        return this.assertionIDRequestServices;
    }

    @Nonnull
    @Live
    public List<AttributeProfile> getAttributeProfiles() {
        return this.attributeProfiles;
    }

    @Nonnull
    @Live
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints() {
        ArrayList<Object> endpoints = new ArrayList<Object>();
        endpoints.addAll(super.getEndpoints());
        endpoints.addAll((Collection<Object>)this.singleSignOnServices);
        endpoints.addAll((Collection<Object>)this.nameIDMappingServices);
        endpoints.addAll((Collection<Object>)this.assertionIDRequestServices);
        return CollectionSupport.copyToList(endpoints);
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints(@Nonnull QName type) {
        if (type.equals(SingleSignOnService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.singleSignOnServices);
        }
        if (type.equals(NameIDMappingService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.nameIDMappingServices);
        }
        if (type.equals(AssertionIDRequestService.DEFAULT_ELEMENT_NAME)) {
            return CollectionSupport.copyToList(this.assertionIDRequestServices);
        }
        return super.getEndpoints(type);
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        List<XMLObject> parentChildren = super.getOrderedChildren();
        if (parentChildren != null) {
            children.addAll(parentChildren);
        }
        children.addAll((Collection<Object>)this.singleSignOnServices);
        children.addAll((Collection<Object>)this.nameIDMappingServices);
        children.addAll((Collection<Object>)this.assertionIDRequestServices);
        children.addAll((Collection<Object>)this.attributeProfiles);
        children.addAll((Collection<Object>)this.attributes);
        return CollectionSupport.copyToList(children);
    }
}

