/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import jakarta.servlet.ServletContext;
import java.security.AccessController;

class SecurityActions {
    SecurityActions() {
    }

    static HttpSessionImpl forSession(Session session, ServletContext servletContext, boolean newSession) {
        if (System.getSecurityManager() == null) {
            return HttpSessionImpl.forSession(session, servletContext, newSession);
        }
        return AccessController.doPrivileged(() -> HttpSessionImpl.forSession(session, servletContext, newSession));
    }

    static ServletRequestContext requireCurrentServletRequestContext() {
        if (System.getSecurityManager() == null) {
            return ServletRequestContext.requireCurrent();
        }
        return AccessController.doPrivileged(ServletRequestContext::requireCurrent);
    }
}

