/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.attribute.CompositeExchangeAttribute;
import io.undertow.attribute.ConstantExchangeAttribute;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ExchangeAttributeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;

public class ExchangeAttributeParser {
    private final List<ExchangeAttributeBuilder> builders;
    private final List<ExchangeAttributeWrapper> wrappers;

    ExchangeAttributeParser(ClassLoader classLoader, List<ExchangeAttributeWrapper> wrappers) {
        this.wrappers = wrappers;
        ServiceLoader<ExchangeAttributeBuilder> loader = ServiceLoader.load(ExchangeAttributeBuilder.class, classLoader);
        ArrayList<ExchangeAttributeBuilder> builders = new ArrayList<ExchangeAttributeBuilder>();
        for (ExchangeAttributeBuilder instance : loader) {
            builders.add(instance);
        }
        Collections.sort(builders, new Comparator<ExchangeAttributeBuilder>(){

            @Override
            public int compare(ExchangeAttributeBuilder o1, ExchangeAttributeBuilder o2) {
                return Integer.compare(o2.priority(), o1.priority());
            }
        });
        this.builders = Collections.unmodifiableList(builders);
    }

    public ExchangeAttribute parse(String valueString) {
        ArrayList<ExchangeAttribute> attributes = new ArrayList<ExchangeAttribute>();
        int pos = 0;
        int state = 0;
        int braceDepth = 0;
        block7: for (int i = 0; i < valueString.length(); ++i) {
            char c = valueString.charAt(i);
            switch (state) {
                case 0: {
                    if (c != '%' && c != '$') continue block7;
                    if (pos != i) {
                        attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i))));
                        pos = i;
                    }
                    if (c == '%') {
                        state = 1;
                        continue block7;
                    }
                    state = 3;
                    continue block7;
                }
                case 1: {
                    if (c == '{') {
                        state = 2;
                        ++braceDepth;
                        continue block7;
                    }
                    if (c == '%') {
                        attributes.add(this.wrap(new ConstantExchangeAttribute("%")));
                        pos = i + 1;
                        state = 0;
                        continue block7;
                    }
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i + 1))));
                    pos = i + 1;
                    state = 0;
                    continue block7;
                }
                case 2: {
                    if (c == '{') {
                        ++braceDepth;
                        continue block7;
                    }
                    if (c != '}' || --braceDepth != 0) continue block7;
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i + 1))));
                    pos = i + 1;
                    state = 0;
                    continue block7;
                }
                case 3: {
                    if (c == '{') {
                        state = 4;
                        ++braceDepth;
                        continue block7;
                    }
                    if (c == '$') {
                        attributes.add(this.wrap(new ConstantExchangeAttribute("$")));
                        pos = i + 1;
                        state = 0;
                        continue block7;
                    }
                    attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i + 1))));
                    pos = i + 1;
                    state = 0;
                    continue block7;
                }
                case 4: {
                    if (c == '}') {
                        if (--braceDepth != 0) continue block7;
                        attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos, i + 1))));
                        pos = i + 1;
                        state = 0;
                        continue block7;
                    }
                    if (c != '{') continue block7;
                    ++braceDepth;
                }
            }
        }
        if (state != 0 || braceDepth != 0) {
            throw UndertowMessages.MESSAGES.mismatchedBraces(valueString);
        }
        if (pos != valueString.length()) {
            attributes.add(this.wrap(this.parseSingleToken(valueString.substring(pos))));
        }
        if (attributes.size() == 1) {
            return (ExchangeAttribute)attributes.get(0);
        }
        return new CompositeExchangeAttribute(attributes.toArray(new ExchangeAttribute[attributes.size()]));
    }

    public ExchangeAttribute parseSingleToken(String token) {
        for (ExchangeAttributeBuilder builder : this.builders) {
            ExchangeAttribute res = builder.build(token);
            if (res == null) continue;
            return res;
        }
        if (token.startsWith("%")) {
            UndertowLogger.ROOT_LOGGER.unknownVariable(token);
        }
        return new ConstantExchangeAttribute(token);
    }

    private ExchangeAttribute wrap(ExchangeAttribute attribute) {
        ExchangeAttribute res = attribute;
        for (ExchangeAttributeWrapper w : this.wrappers) {
            res = w.wrap(res);
        }
        return res;
    }
}

