/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.controller;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.generator.configuration.controller.OutletReference;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.source.PostprocessorDefinition;
import org.apache.torque.generator.source.SourceProcessConfiguration;
import org.apache.torque.generator.source.SourceProvider;

public class Output {
    private static final String CARRIAGE_RETURN = "\r";
    private static final String LINE_FEED = "\n";
    private static final String CARRIAGE_RETURN_LINE_FEED = "\r\n";
    private final QualifiedName name;
    private SourceProvider sourceProvider;
    private SourceProcessConfiguration sourceProcessConfiguration;
    private final List<PostprocessorDefinition> postprocessorDefinitions = new ArrayList<PostprocessorDefinition>();
    private OutletReference contentOutlet;
    private Outlet filenameOutlet;
    private String filename;
    private String existingTargetStrategy = "replace";
    private String type = "unknown";
    private String lineBreak;
    private String outputDirKey;
    private Charset charSet;

    public Output(QualifiedName name) {
        this.name = name;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    public SourceProcessConfiguration getSourceProcessConfiguration() {
        return this.sourceProcessConfiguration;
    }

    public void setSourceProcessConfiguration(SourceProcessConfiguration sourceProcessConfiguration) {
        this.sourceProcessConfiguration = sourceProcessConfiguration;
    }

    public List<PostprocessorDefinition> getPostprocessorDefinitions() {
        return this.postprocessorDefinitions;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public OutletReference getContentOutlet() {
        return this.contentOutlet;
    }

    public void setContentOutlet(OutletReference contentOutlet) {
        this.contentOutlet = contentOutlet;
    }

    public Outlet getFilenameOutlet() {
        return this.filenameOutlet;
    }

    public void setFilenameOutlet(Outlet filenameOutlet) {
        this.filenameOutlet = filenameOutlet;
    }

    public String getExistingTargetStrategy() {
        return this.existingTargetStrategy;
    }

    public void setExistingTargetStrategy(String existingTargetStrategy) {
        this.existingTargetStrategy = existingTargetStrategy;
    }

    public String getOutputDirKey() {
        return this.outputDirKey;
    }

    public void setOutputDirKey(String outputKeyDir) {
        this.outputDirKey = outputKeyDir;
    }

    public Charset getEncoding() {
        return this.charSet;
    }

    public void setEncoding(Charset charSet) {
        this.charSet = charSet;
    }

    public void setType(String type) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getOrDetermineLineBreak(String content) {
        if (this.lineBreak != null) {
            return this.lineBreak;
        }
        String contentString = content.toString();
        int r = StringUtils.countMatches((CharSequence)contentString, (CharSequence)CARRIAGE_RETURN);
        int n = StringUtils.countMatches((CharSequence)contentString, (CharSequence)LINE_FEED);
        int rn = StringUtils.countMatches((CharSequence)contentString, (CharSequence)CARRIAGE_RETURN_LINE_FEED);
        if (rn >= r - rn || rn >= n - rn) {
            if (rn > 0) {
                this.lineBreak = CARRIAGE_RETURN_LINE_FEED;
            }
            return CARRIAGE_RETURN_LINE_FEED;
        }
        if (n > r) {
            this.lineBreak = LINE_FEED;
            return LINE_FEED;
        }
        this.lineBreak = CARRIAGE_RETURN;
        return CARRIAGE_RETURN;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("(OutputFile: sourceProvider=").append(this.sourceProvider).append(",existingTargetStrategy=").append(this.existingTargetStrategy).append(",charSet=").append(this.charSet).append(",filenameOutlet=").append(this.filenameOutlet).append(",contentOutlet=").append(this.contentOutlet).append(",type=").append(this.type).append(")");
        return result.toString();
    }
}

