/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.AbstractAdapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.sql.Query;

public class MssqlAdapter
extends AbstractAdapter {
    private static final long serialVersionUID = -2924485528975497044L;

    protected MssqlAdapter() {
    }

    @Override
    public String toUpperCase(String in) {
        return "UPPER(" + in + ")";
    }

    @Override
    public String ignoreCase(String in) {
        return "UPPER(" + in + ")";
    }

    @Override
    public IDMethod getIDMethodType() {
        return IDMethod.AUTO_INCREMENT;
    }

    @Override
    public String getIDMethodSQL(Object unused) {
        return "select @@identity";
    }

    @Override
    public String getUpdateLockClause() {
        return "WITH (UPDLOCK)";
    }

    @Override
    public void lockTable(Connection con, String table) throws SQLException {
        try (Statement statement = con.createStatement();){
            statement.execute("SELECT * FROM " + table + " WITH (TABLOCKX)");
        }
    }

    @Override
    public void unlockTable(Connection con, String table) throws SQLException {
    }

    @Override
    public boolean supportsNativeOffset() {
        return false;
    }

    @Override
    public void generateLimits(Query query, long offset, int limit) throws TorqueException {
        if (limit < 0 && offset >= 0L) {
            return;
        }
        if ((long)limit + offset > 0L) {
            query.setRowcount(String.valueOf((long)limit + offset));
        } else if ((long)limit + offset == 0L) {
            query.getWhereClause().add("1=0");
        }
    }

    @Override
    public boolean escapeText() {
        return false;
    }

    @Override
    public boolean useEscapeClauseForLike() {
        return true;
    }
}

