/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.intermediate.syncrepl_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl.SyncInfoValue;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl.SynchronizationInfoEnum;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl_impl.SyncInfoValueContainer;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl_impl.SyncInfoValueStatesEnum;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl_impl.SyncInfoValueTags;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncInfoValueGrammar
extends AbstractGrammar<SyncInfoValueContainer> {
    static final Logger LOG = LoggerFactory.getLogger(SyncInfoValueGrammar.class);
    private static Grammar<SyncInfoValueContainer> instance = new SyncInfoValueGrammar();

    private SyncInfoValueGrammar() {
        this.setName(SyncInfoValueGrammar.class.getName());
        this.transitions = new GrammarTransition[SyncInfoValueStatesEnum.LAST_SYNC_INFO_VALUE_STATE.ordinal()][256];
        this.transitions[SyncInfoValueStatesEnum.START_STATE.ordinal()][SyncInfoValueTags.NEW_COOKIE_TAG.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.START_STATE, (Enum)SyncInfoValueStatesEnum.NEW_COOKIE_STATE, SyncInfoValueTags.NEW_COOKIE_TAG.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("NewCookie choice for SyncInfoValue response"){

            public void action(SyncInfoValueContainer container) {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                syncInfoValue.setSyncInfoValueType(SynchronizationInfoEnum.NEW_COOKIE);
                BerValue value = container.getCurrentTLV().getValue();
                byte[] newCookie = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08300_NEW_COOKIE, (Object[])new Object[]{Strings.dumpBytes((byte[])newCookie)}));
                }
                syncInfoValue.setCookie(newCookie);
                container.setGrammarEndAllowed(true);
                container.setSyncInfoValue(syncInfoValue);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.START_STATE.ordinal()][SyncInfoValueTags.REFRESH_DELETE_TAG.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.START_STATE, (Enum)SyncInfoValueStatesEnum.REFRESH_DELETE_STATE, SyncInfoValueTags.REFRESH_DELETE_TAG.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("RefreshDelete choice for SyncInfoValue response"){

            public void action(SyncInfoValueContainer container) {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                syncInfoValue.setSyncInfoValueType(SynchronizationInfoEnum.REFRESH_DELETE);
                container.setSyncInfoValue(syncInfoValue);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_DELETE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.REFRESH_DELETE_STATE, (Enum)SyncInfoValueStatesEnum.REFRESH_DELETE_COOKIE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("RefreshDelete cookie"){

            public void action(SyncInfoValueContainer container) {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08000_COOKIE, (Object[])new Object[]{Strings.dumpBytes((byte[])cookie)}));
                }
                container.getSyncInfoValue().setCookie(cookie);
                container.setSyncInfoValue(syncInfoValue);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_DELETE_COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.REFRESH_DELETE_COOKIE_STATE, (Enum)SyncInfoValueStatesEnum.LAST_SYNC_INFO_VALUE_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("RefreshDelete refreshDone flag"){

            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse((BerValue)value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_08301_REFRESH_DONE, (Object[])new Object[]{refreshDone}));
                    }
                    syncInfoValue.setRefreshDone(refreshDone);
                    container.setSyncInfoValue(syncInfoValue);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err((I18n)I18n.ERR_08300_REFRESH_DONE_DECODING_FAILED, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg, (Throwable)be);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_DELETE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.REFRESH_DELETE_STATE, (Enum)SyncInfoValueStatesEnum.LAST_SYNC_INFO_VALUE_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("RefreshDelete refreshDone flag"){

            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse((BerValue)value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_08301_REFRESH_DONE, (Object[])new Object[]{refreshDone}));
                    }
                    syncInfoValue.setRefreshDone(refreshDone);
                    container.setSyncInfoValue(syncInfoValue);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err((I18n)I18n.ERR_08300_REFRESH_DONE_DECODING_FAILED, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg, (Throwable)be);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.START_STATE.ordinal()][SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.START_STATE, (Enum)SyncInfoValueStatesEnum.REFRESH_PRESENT_STATE, SyncInfoValueTags.REFRESH_PRESENT_TAG.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("RefreshDelete choice for SyncInfoValue response"){

            public void action(SyncInfoValueContainer container) {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                syncInfoValue.setSyncInfoValueType(SynchronizationInfoEnum.REFRESH_PRESENT);
                container.setSyncInfoValue(syncInfoValue);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_PRESENT_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.REFRESH_PRESENT_STATE, (Enum)SyncInfoValueStatesEnum.REFRESH_PRESENT_COOKIE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("RefreshPresent cookie"){

            public void action(SyncInfoValueContainer container) {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08000_COOKIE, (Object[])new Object[]{Strings.dumpBytes((byte[])cookie)}));
                }
                container.getSyncInfoValue().setCookie(cookie);
                container.setSyncInfoValue(syncInfoValue);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_PRESENT_COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.REFRESH_PRESENT_COOKIE_STATE, (Enum)SyncInfoValueStatesEnum.LAST_SYNC_INFO_VALUE_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("RefreshPresent refreshDone flag"){

            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse((BerValue)value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_08301_REFRESH_DONE, (Object[])new Object[]{refreshDone}));
                    }
                    syncInfoValue.setRefreshDone(refreshDone);
                    container.setSyncInfoValue(syncInfoValue);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err((I18n)I18n.ERR_08300_REFRESH_DONE_DECODING_FAILED, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg, (Throwable)be);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.REFRESH_PRESENT_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.REFRESH_PRESENT_STATE, (Enum)SyncInfoValueStatesEnum.LAST_SYNC_INFO_VALUE_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("RefreshPresent refreshDone flag"){

            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDone = BooleanDecoder.parse((BerValue)value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_08301_REFRESH_DONE, (Object[])new Object[]{refreshDone}));
                    }
                    syncInfoValue.setRefreshDone(refreshDone);
                    container.setSyncInfoValue(syncInfoValue);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err((I18n)I18n.ERR_08300_REFRESH_DONE_DECODING_FAILED, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg, (Throwable)be);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.START_STATE.ordinal()][SyncInfoValueTags.SYNC_ID_SET_TAG.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.START_STATE, (Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_STATE, SyncInfoValueTags.SYNC_ID_SET_TAG.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("SyncIdSet choice for SyncInfoValue response"){

            public void action(SyncInfoValueContainer container) {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                syncInfoValue.setSyncInfoValueType(SynchronizationInfoEnum.SYNC_ID_SET);
                container.setSyncInfoValue(syncInfoValue);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_STATE, (Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_COOKIE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("SyncIdSet cookie"){

            public void action(SyncInfoValueContainer container) {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08000_COOKIE, (Object[])new Object[]{Strings.dumpBytes((byte[])cookie)}));
                }
                container.getSyncInfoValue().setCookie(cookie);
                container.setSyncInfoValue(syncInfoValue);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_STATE, (Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_REFRESH_DELETES_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("SyncIdSet refreshDeletes"){

            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDeletes = BooleanDecoder.parse((BerValue)value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_08001_REFRESH_DELETES, (Object[])new Object[]{refreshDeletes}));
                    }
                    syncInfoValue.setRefreshDeletes(refreshDeletes);
                    container.setSyncInfoValue(syncInfoValue);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err((I18n)I18n.ERR_08301_REFRESH_DELETES_DECODING_FAILED, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg, (Throwable)be);
                }
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_COOKIE_STATE, (Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_REFRESH_DELETES_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("SyncIdSet refreshDeletes"){

            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDeletes = BooleanDecoder.parse((BerValue)value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_08001_REFRESH_DELETES, (Object[])new Object[]{refreshDeletes}));
                    }
                    syncInfoValue.setRefreshDeletes(refreshDeletes);
                    container.setSyncInfoValue(syncInfoValue);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err((I18n)I18n.ERR_08001_CANNOT_DECODE_REFRESH_DELETES, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg, (Throwable)be);
                }
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_STATE.ordinal()][UniversalTag.SET.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_STATE, (Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_SET_OF_UUIDS_STATE, (int)UniversalTag.SET.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("SyncIdSet syncUUIDs"){

            public void action(SyncInfoValueContainer container) {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_COOKIE_STATE.ordinal()][UniversalTag.SET.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_COOKIE_STATE, (Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_SET_OF_UUIDS_STATE, (int)UniversalTag.SET.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("SyncIdSet syncUUIDs"){

            public void action(SyncInfoValueContainer container) {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_REFRESH_DELETES_STATE.ordinal()][UniversalTag.SET.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_REFRESH_DELETES_STATE, (Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_SET_OF_UUIDS_STATE, (int)UniversalTag.SET.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("SyncIdSet syncUUIDs"){

            public void action(SyncInfoValueContainer container) {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_SET_OF_UUIDS_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_SET_OF_UUIDS_STATE, (Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_UUID_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("SyncIdSet first UUID"){

            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] uuid = value.getData();
                if (uuid == null || uuid.length != 16) {
                    String msg = I18n.err((I18n)I18n.ERR_08302_BAD_UUID_VALUE_INCORRECT_LENGTH, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08302_UUID, (Object[])new Object[]{Strings.dumpBytes((byte[])uuid)}));
                }
                syncInfoValue.addSyncUUID(uuid);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncInfoValueStatesEnum.SYNC_ID_SET_UUID_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_UUID_STATE, (Enum)SyncInfoValueStatesEnum.SYNC_ID_SET_UUID_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<SyncInfoValueContainer>("SyncIdSet UUID"){

            public void action(SyncInfoValueContainer container) throws DecoderException {
                SyncInfoValue syncInfoValue = container.getSyncInfoValue();
                BerValue value = container.getCurrentTLV().getValue();
                byte[] uuid = value.getData();
                if (uuid == null || uuid.length != 16) {
                    String msg = I18n.err((I18n)I18n.ERR_08302_BAD_UUID_VALUE_INCORRECT_LENGTH, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08302_UUID, (Object[])new Object[]{Strings.dumpBytes((byte[])uuid)}));
                }
                syncInfoValue.getSyncUUIDs().add(uuid);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<SyncInfoValueContainer> getInstance() {
        return instance;
    }
}

