/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.segment.nested;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

public class LocalDimensionDictionary
{
  private final Int2IntOpenHashMap globalIdToLocalId = new Int2IntOpenHashMap();

  private int nextLocalId = 0;

  public LocalDimensionDictionary()
  {
    this.globalIdToLocalId.defaultReturnValue(-1);
  }

  public Int2IntOpenHashMap getGlobalIdToLocalId()
  {
    return globalIdToLocalId;
  }
  
  public int add(int originalValue)
  {
    int prev = globalIdToLocalId.get(originalValue);
    if (prev >= 0) {
      return prev;
    }
    final int index = nextLocalId++;
    globalIdToLocalId.put(originalValue, index);

    return index;
  }

  public int size()
  {
    return nextLocalId;
  }
}
