/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBShardGroupsRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBShardGroupsRequestMarshaller
implements Marshaller<Request<DescribeDBShardGroupsRequest>, DescribeDBShardGroupsRequest> {
    public Request<DescribeDBShardGroupsRequest> marshall(DescribeDBShardGroupsRequest describeDBShardGroupsRequest) {
        if (describeDBShardGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBShardGroupsRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBShardGroups");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBShardGroupsRequest.getDBShardGroupIdentifier() != null) {
            request.addParameter("DBShardGroupIdentifier", StringUtils.fromString((String)describeDBShardGroupsRequest.getDBShardGroupIdentifier()));
        }
        if (!describeDBShardGroupsRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBShardGroupsRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBShardGroupsRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBShardGroupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBShardGroupsRequest.getMarker()));
        }
        if (describeDBShardGroupsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBShardGroupsRequest.getMaxRecords()));
        }
        return request;
    }
}

