/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import org.apache.druid.data.input.kafka.KafkaTopicPartition;
import org.apache.druid.indexing.kafka.KafkaSeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.kafka.KafkaSeekableStreamStartSequenceNumbers;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.seekablestream.SeekableStreamDataSourceMetadata;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.CollectionUtils;
import org.apache.kafka.common.TopicPartition;

public class KafkaDataSourceMetadata
extends SeekableStreamDataSourceMetadata<KafkaTopicPartition, Long>
implements Comparable<KafkaDataSourceMetadata> {
    private static final Logger LOGGER = new Logger(KafkaDataSourceMetadata.class);

    @JsonCreator
    public KafkaDataSourceMetadata(@JsonProperty(value="partitions") SeekableStreamSequenceNumbers<KafkaTopicPartition, Long> kafkaPartitions) {
        super(kafkaPartitions == null ? null : (kafkaPartitions instanceof SeekableStreamStartSequenceNumbers ? new KafkaSeekableStreamStartSequenceNumbers(kafkaPartitions.getStream(), ((SeekableStreamStartSequenceNumbers)kafkaPartitions).getTopic(), kafkaPartitions.getPartitionSequenceNumberMap(), ((SeekableStreamStartSequenceNumbers)kafkaPartitions).getPartitionOffsetMap(), ((SeekableStreamStartSequenceNumbers)kafkaPartitions).getExclusivePartitions()) : new KafkaSeekableStreamEndSequenceNumbers(kafkaPartitions.getStream(), ((SeekableStreamEndSequenceNumbers)kafkaPartitions).getTopic(), kafkaPartitions.getPartitionSequenceNumberMap(), ((SeekableStreamEndSequenceNumbers)kafkaPartitions).getPartitionOffsetMap())));
    }

    public DataSourceMetadata asStartMetadata() {
        SeekableStreamSequenceNumbers sequenceNumbers = this.getSeekableStreamSequenceNumbers();
        if (sequenceNumbers instanceof SeekableStreamEndSequenceNumbers) {
            return this.createConcreteDataSourceMetaData((SeekableStreamSequenceNumbers<KafkaTopicPartition, Long>)((SeekableStreamEndSequenceNumbers)sequenceNumbers).asStartPartitions(true));
        }
        return this;
    }

    protected SeekableStreamDataSourceMetadata<KafkaTopicPartition, Long> createConcreteDataSourceMetaData(SeekableStreamSequenceNumbers<KafkaTopicPartition, Long> seekableStreamSequenceNumbers) {
        return new KafkaDataSourceMetadata(seekableStreamSequenceNumbers);
    }

    @Override
    public int compareTo(KafkaDataSourceMetadata other) {
        if (!this.getClass().equals(other.getClass())) {
            throw new IAE("Expected instance of %s, got %s", new Object[]{this.getClass().getName(), other.getClass().getName()});
        }
        return this.getSeekableStreamSequenceNumbers().compareTo(other.getSeekableStreamSequenceNumbers(), Comparator.naturalOrder());
    }

    public boolean matches(DataSourceMetadata other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        KafkaDataSourceMetadata thisPlusOther = (KafkaDataSourceMetadata)this.plus(other);
        if (thisPlusOther.equals(other.plus((DataSourceMetadata)this))) {
            return true;
        }
        KafkaDataSourceMetadata otherMetadata = (KafkaDataSourceMetadata)other;
        SeekableStreamSequenceNumbers otherSequenceNumbers = otherMetadata.getSeekableStreamSequenceNumbers();
        if (!this.getSeekableStreamSequenceNumbers().isMultiTopicPartition() && !otherSequenceNumbers.isMultiTopicPartition()) {
            return false;
        }
        SeekableStreamSequenceNumbers mergedSequenceNumbers = thisPlusOther.getSeekableStreamSequenceNumbers();
        Map topicAndPartitionToSequenceNumber = CollectionUtils.mapKeys((Map)mergedSequenceNumbers.getPartitionSequenceNumberMap(), k -> k.asTopicPartition(mergedSequenceNumbers.getStream()));
        boolean allOtherFoundAndConsistent = otherSequenceNumbers.getPartitionSequenceNumberMap().entrySet().stream().noneMatch(e -> {
            KafkaTopicPartition kafkaTopicPartition = (KafkaTopicPartition)e.getKey();
            TopicPartition topicPartition = kafkaTopicPartition.asTopicPartition(otherSequenceNumbers.getStream());
            Long sequenceOffset = (Long)topicAndPartitionToSequenceNumber.get(topicPartition);
            long oldSequenceOffset = (Long)e.getValue();
            if (sequenceOffset == null || !sequenceOffset.equals(oldSequenceOffset)) {
                LOGGER.info("sequenceOffset found for currently computed and stored metadata does not match for topicPartition: [%s].  currentSequenceOffset: [%s], oldSequenceOffset: [%s]", new Object[]{topicPartition, sequenceOffset, oldSequenceOffset});
                return true;
            }
            return false;
        });
        boolean allThisFoundAndConsistent = this.getSeekableStreamSequenceNumbers().getPartitionSequenceNumberMap().entrySet().stream().noneMatch(e -> {
            KafkaTopicPartition kafkaTopicPartition = (KafkaTopicPartition)e.getKey();
            TopicPartition topicPartition = kafkaTopicPartition.asTopicPartition(this.getSeekableStreamSequenceNumbers().getStream());
            Long oldSequenceOffset = (Long)topicAndPartitionToSequenceNumber.get(topicPartition);
            long sequenceOffset = (Long)e.getValue();
            if (oldSequenceOffset == null || !oldSequenceOffset.equals(sequenceOffset)) {
                LOGGER.info("sequenceOffset found for currently computed and stored metadata does not match for topicPartition: [%s].  currentSequenceOffset: [%s], oldSequenceOffset: [%s]", new Object[]{topicPartition, sequenceOffset, oldSequenceOffset});
                return true;
            }
            return false;
        });
        return allOtherFoundAndConsistent && allThisFoundAndConsistent;
    }
}

