/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.SafeWritableMemory;

public class SketchHolderObjectStrategy
implements ObjectStrategy<SketchHolder> {
    public int compare(SketchHolder s1, SketchHolder s2) {
        return SketchHolder.COMPARATOR.compare(s1, s2);
    }

    public Class<SketchHolder> getClazz() {
        return SketchHolder.class;
    }

    public SketchHolder fromByteBuffer(ByteBuffer buffer, int numBytes) {
        if (numBytes == 0) {
            return SketchHolder.EMPTY;
        }
        return SketchHolder.of(Memory.wrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.LITTLE_ENDIAN).region((long)buffer.position(), (long)numBytes));
    }

    public byte[] toBytes(@Nullable SketchHolder obj) {
        if (obj != null) {
            Sketch sketch = obj.getSketch();
            if (sketch.isEmpty()) {
                return ByteArrays.EMPTY_ARRAY;
            }
            return sketch.toByteArray();
        }
        return ByteArrays.EMPTY_ARRAY;
    }

    @Nullable
    public SketchHolder fromByteBufferSafe(ByteBuffer buffer, int numBytes) {
        if (numBytes == 0) {
            return SketchHolder.EMPTY;
        }
        return SketchHolder.of(SafeWritableMemory.wrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.LITTLE_ENDIAN).region((long)buffer.position(), (long)numBytes));
    }
}

