/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.executor;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;
import org.apache.felix.hc.core.impl.executor.ExecutionResult;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckFuture
extends FutureTask<ExecutionResult> {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckFuture.class);
    private final HealthCheckMetadata metadata;
    private final Date createdTime = new Date();

    private static Result createResult(HealthCheckMetadata metadata, Exception e) {
        return new Result(Result.Status.HEALTH_CHECK_ERROR, "Exception during execution of '" + metadata.getName() + "'", e);
    }

    public HealthCheckFuture(final HealthCheckMetadata metadata, final BundleContext bundleContext, final Callback callback) {
        super(new Callable<ExecutionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ExecutionResult call() throws Exception {
                ExecutionResult executionResult;
                block9: {
                    Thread.currentThread().setName("HealthCheck " + metadata.getTitle());
                    LOG.debug("Starting check {}", (Object)metadata);
                    long startTime = System.currentTimeMillis();
                    Result resultFromHealthCheck = null;
                    executionResult = null;
                    Object healthCheckObject = bundleContext.getService(metadata.getServiceReference());
                    try {
                        if (healthCheckObject != null) {
                            HealthCheck healthCheck = healthCheckObject instanceof HealthCheck ? (HealthCheck)healthCheckObject : new LegacyHealthCheckWrapper(healthCheckObject);
                            resultFromHealthCheck = healthCheck.execute();
                            break block9;
                        }
                        throw new IllegalStateException("Service cannot be retrieved - probably activate() failed or there are unsatisfied references");
                    }
                    catch (Exception e) {
                        resultFromHealthCheck = HealthCheckFuture.createResult(metadata, e);
                    }
                    catch (Throwable t) {
                        RuntimeException e = new RuntimeException("System error during health check execution", t);
                        resultFromHealthCheck = HealthCheckFuture.createResult(metadata, e);
                    }
                    finally {
                        bundleContext.ungetService(metadata.getServiceReference());
                        long elapsedTime = System.currentTimeMillis() - startTime;
                        if (resultFromHealthCheck != null) {
                            executionResult = new ExecutionResult(metadata, resultFromHealthCheck, elapsedTime);
                        }
                        LOG.debug("Time consumed for {}: {}", (Object)metadata, (Object)FormattingResultLog.msHumanReadable((long)elapsedTime));
                    }
                }
                callback.finished(executionResult);
                Thread.currentThread().setName("HealthCheck-idle");
                return executionResult;
            }
        });
        this.metadata = metadata;
    }

    Date getCreatedTime() {
        return this.createdTime;
    }

    public HealthCheckMetadata getHealthCheckMetadata() {
        return this.metadata;
    }

    @Override
    public String toString() {
        return "[Future for " + this.metadata + ", createdTime=" + this.createdTime + "]";
    }

    private static class LegacyHealthCheckWrapper
    implements HealthCheck {
        private final Object legacyHealthCheck;
        private final FormattingResultLog log;

        public LegacyHealthCheckWrapper(Object legacyHealthCheck) {
            this.legacyHealthCheck = legacyHealthCheck;
            this.log = new FormattingResultLog();
        }

        public Result execute() {
            Object result;
            Class<?> hcClass = this.legacyHealthCheck.getClass();
            this.log.debug("Running legacy HC {}, please convert to new interface org.apache.felix.hc.api.HealthCheck!", new Object[]{hcClass.getName()});
            try {
                Method executeMethod = hcClass.getMethod("execute", new Class[0]);
                result = executeMethod.invoke(this.legacyHealthCheck, new Object[0]);
            }
            catch (InvocationTargetException e) {
                this.log.healthCheckError("Exception during execute() of Sling HC {}: {}", new Object[]{hcClass.getName(), String.valueOf(e.getTargetException()), e});
                return new Result((ResultLog)this.log);
            }
            catch (ReflectiveOperationException e) {
                this.log.healthCheckError("Could not call Sling HC {} from Felix Runtime: {}", new Object[]{hcClass.getName(), String.valueOf(e), e});
                return new Result((ResultLog)this.log);
            }
            try {
                Object resultLog = this.readPrivateField(result, "resultLog");
                List entries = (List)this.readPrivateField(resultLog, "entries");
                if (entries != null) {
                    for (Object object : entries) {
                        String statusLegacy = String.valueOf(this.readPrivateField(object, "status"));
                        String message = (String)this.readPrivateField(object, "message");
                        Exception exception = (Exception)this.readPrivateField(object, "exception");
                        if (statusLegacy.equals("DEBUG")) {
                            this.log.add(new ResultLog.Entry(message, true, exception));
                            continue;
                        }
                        statusLegacy = statusLegacy.replace("INFO", Result.Status.OK.name());
                        this.log.add(new ResultLog.Entry(Result.Status.valueOf((String)statusLegacy), message, exception));
                    }
                }
            }
            catch (ReflectiveOperationException e) {
                this.log.healthCheckError("Could convert Sling HC result of {} for Felix Runtime: {}", new Object[]{hcClass.getName(), String.valueOf(e), e});
            }
            return new Result((ResultLog)this.log);
        }

        private Object readPrivateField(Object target, String fieldName) throws ReflectiveOperationException {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
    }

    public static interface Callback {
        public void finished(HealthCheckExecutionResult var1);
    }
}

