/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.tracker;

import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractTracker<T>
extends ServiceTracker<T, T> {
    public AbstractTracker(BundleContext context, Filter filter) {
        super(context, filter, null);
    }

    public AbstractTracker(BundleContext context, Class<T> clazz) {
        super(context, clazz.getName(), null);
    }

    protected void logDeprecationWarning(String id, T service, ServiceReference<T> ref) {
        SystemLogger.warning("Deprecation warning: " + id + " registered through Apache Felix whiteboard service: " + this.getInfo(service, ref) + ". Please change your code to use the OSGi Http Whiteboard Service.", null);
    }

    private String getInfo(T service, ServiceReference<T> ref) {
        return "Service " + ref.getProperty("service.pid") + " from bundle " + ref.getBundle().getBundleId() + (ref.getBundle().getSymbolicName() != null ? ref.getBundle().getSymbolicName() + ":" + ref.getBundle().getVersion() : "") + " class " + service.getClass();
    }

    public final T addingService(ServiceReference<T> ref) {
        Object service = super.addingService(ref);
        this.added(service, ref);
        return (T)service;
    }

    public final void modifiedService(ServiceReference<T> ref, T service) {
        this.removed(service, ref);
        this.added(service, ref);
    }

    public final void removedService(ServiceReference<T> ref, T service) {
        super.removedService(ref, service);
        this.removed(service, ref);
    }

    protected abstract void added(T var1, ServiceReference<T> var2);

    protected abstract void removed(T var1, ServiceReference<T> var2);
}

