/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.dependency.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.ipojo.util.DependencyModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyProperties {
    public static Dictionary<String, ?> getDependencyProperties(DependencyModel dependency) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("instance.name", dependency.getComponentInstance().getInstanceName());
        ((Dictionary)properties).put("instance.state", dependency.getComponentInstance().getState());
        ((Dictionary)properties).put("factory.name", dependency.getComponentInstance().getFactory().getFactoryName());
        Bundle bundle = dependency.getBundleContext().getBundle();
        ((Dictionary)properties).put("bundle.symbolicName", bundle.getSymbolicName());
        if (bundle.getVersion() != null) {
            ((Dictionary)properties).put("bundle.version", bundle.getVersion().toString());
        }
        Class specification = dependency.getSpecification();
        ((Dictionary)properties).put("dependency.specification", specification.getName());
        ((Dictionary)properties).put("dependency.id", dependency.getId());
        ((Dictionary)properties).put("dependency.state", dependency.getState());
        ArrayList<String> classes = new ArrayList<String>();
        classes.add(specification.getName());
        for (Class<?> clazz : specification.getInterfaces()) {
            classes.add(clazz.getName());
        }
        ((Dictionary)properties).put("objectClass", classes.toArray(new String[classes.size()]));
        return properties;
    }

    public static boolean match(ServiceReference reference, DependencyModel dependency, BundleContext context) {
        Object v = reference.getProperty("target");
        Filter filter = null;
        if (v == null) {
            return false;
        }
        if (v instanceof Filter) {
            filter = (Filter)v;
        } else if (v instanceof String) {
            try {
                filter = context.createFilter((String)v);
            }
            catch (InvalidSyntaxException e) {
                dependency.getComponentInstance().getFactory().getLogger().log(1, "Cannot build filter from the target property : " + v, e);
            }
        }
        if (filter == null) {
            return false;
        }
        Dictionary<String, ?> properties = DependencyProperties.getDependencyProperties(dependency);
        return filter.match(properties);
    }

    public static boolean match(ServiceReference reference, DependencyModel dependency) {
        return DependencyProperties.match(reference, dependency, dependency.getBundleContext());
    }
}

